// ANY SCREEN FADER -- January 21, 1995
// Coded by HOOPTiE of Sector Logic
// --------------------------------------------------------------------------
// This program will do perform screen fades beginning with a simple 16 color
// text screen upto 256 color graphic screen (regarless of resolution).  On
// some machines, correct palette information is NOT read correctly the first
// time and the problem is hardware specific.  The only solution I am aware
// of is reading the RGB values twice.  Since an interrupt is NOT called to
// perform these functions, there is virtually NO performance deficiency
// from the extra call.
// --------------------------------------------------------------------------

// INCLUDED HEADER FILES
	#include <conio.h>

// DEFINITIONS
	#define PALETTE_MASK           0x3c6
	#define PALETTE_REGISTER_RD    0x3c7
	#define PALETTE_REGISTER_WR    0x3c8
	#define PALETTE_DATA           0x3c9

// STRUCTURES
	typedef struct RGB_color_typ {
		int red;    // red   component of color 0-63
		int green;  // green component of color 0-63
		int blue;   // blue  component of color 0-63
	} RGB_color, *RGB_color_ptr;

// PROTOTYPES
	void Set_Palette_Register(int index, RGB_color_ptr color);
	void Get_Palette_Register(int index, RGB_color_ptr color);
	void Reset_Palette(RGB_color palette[256]);
	void Fade_Screen(int speed, RGB_color palette[256]);


// FUNCTIONS

	void Set_Palette_Register(int index, RGB_color_ptr color)
	{
	// SET_PALETTE_REGISTER sets a single palette register with RED, GREEN,
	// and BLUE values from COLOR.

	// Initiate the palette update
		outp(PALETTE_MASK,0xff);

	// What register to update
		outp(PALETTE_REGISTER_WR, index);

	// Update the RGB values
		outp(PALETTE_DATA,color->red);
		outp(PALETTE_DATA,color->green);
		outp(PALETTE_DATA,color->blue);
	}

	void Get_Palette_Register(int index, RGB_color_ptr color)
	{
	// GET_PALETTE_REGISTER retrieves the RED, GREEN, and BLUE byte data from
	// the palette and places them into the COLOR structure

	// Set the palette mask register
		outp(PALETTE_MASK,0xff);

	// Indicate the register number
		outp(PALETTE_REGISTER_RD, index);

	// Read the data
		color->red   = inp(PALETTE_DATA);
		color->green = inp(PALETTE_DATA);
		color->blue  = inp(PALETTE_DATA);
	}

	void Reset_Palette(RGB_color palette[256])
	{
	// RESET_PALETTE is a simple way to set ALL of the palette registers at
	// one time.
		for (int index=0; index<256; index++)
				Set_Palette_Register(index,(RGB_color_ptr)&palette[index]);
	}


	void Fade_Screen(int speed, RGB_color palette[256])
	{
	// FADE_SCREEN is actually a palette transformation algorythm that
	// changes the current palette to the palette passed to it.  This
	// code can be SIGNIFICANLY simplified by using constants instead of
	// variables (ie, RGB directions, etc).  If you are going to use this
	// routine for TEXTMODEs only, reduce the index fro 256 to 64 (the
	// text modes only have 64 color attributes) which will increase the
	// speed of execution by about 4 times.

		RGB_color color;                                        // Current palette register
		int r_dir=0, g_dir=0, b_dir=0;  // RGB direction

		for (int fade=0; fade<(63/speed); fade++) {
			for (int index=0; index<256; index++) {
			// Read the palette register data
				Get_Palette_Register(index,(RGB_color_ptr)&color);
				Get_Palette_Register(index,(RGB_color_ptr)&color);

			// Set RGB directions
				r_dir=0; g_dir=0; b_dir=0;                                                                      // Assume no palette adjustment is necessary
				if (color.red<palette[index].red) r_dir=1;                      // Adjust red brighter
				if (color.green<palette[index].green) g_dir=1;          // Adjust green brighter
				if (color.blue<palette[index].blue) b_dir=1;                    // Adjust blue brighter
				if (color.red>palette[index].red) r_dir=-1;                     // Adjust red dimmer
				if (color.green>palette[index].green) g_dir=-1;         // Adjust green dimmer
				if (color.blue>palette[index].blue) b_dir=-1;           // Adjust blue dimmer

			// Make any adjustments
				color.red+=speed*r_dir;
				color.green+=speed*g_dir;
				color.blue+=speed*b_dir;

			// Ensure data is within range
				if ((r_dir<0)&&(color.red<palette[index].red)) color.red=palette[index].red;
				if ((g_dir<0)&&(color.green<palette[index].green)) color.green=palette[index].green;
				if ((b_dir<0)&&(color.blue<palette[index].blue)) color.blue=palette[index].blue;
				if ((r_dir>0)&&(color.red>palette[index].red)) color.red=palette[index].red;
				if ((g_dir>0)&&(color.green>palette[index].green)) color.green=palette[index].green;
				if ((b_dir>0)&&(color.blue>palette[index].blue)) color.blue=palette[index].blue;

			// Set the new values
				Set_Palette_Register(index,(RGB_color_ptr)&color);
			}
		}
	}
/*
// MAIN PROGRAM LOOP
	void main(void)
	{
		RGB_color original_pal[256];    // Original color palette
		RGB_color work_pal[256];      // Palette to work with

	// Save the original palette
		for (int x=0; x<256; x++) {
			Get_Palette_Register(x,(RGB_color_ptr)&original_pal[x]);
			Get_Palette_Register(x,(RGB_color_ptr)&original_pal[x]);
		}

	// Create an all BLACK work palette
		for (x=0; x<256; x++) {
			work_pal[x].red=0;
			work_pal[x].green=0;
			work_pal[x].blue=0;
		}

		Fade_Screen(2,work_pal);
		getch();
		Reset_Palette(original_pal);
	}
*/

