{TITLE: Turbo/IBM CGA - Resident Hi-Ascii Font - Editable!
Ascii chars from 128 to 255 are normally not available when in graphics
mode on the CGA. The following Turbo program loads a font table that
gives access to the very same characters available while in text mode.
Additionally, the program has the various representations for Ascii 128
thru 255 in a typed const that you can easily modify and CREATE YOUR OWN
FONT! A portion of the .COM file remains resident and takes up less than
1300 bytes of RAM! This has not been tested under Turbo v2 but works fine
under v3.x.   Enjoy!  - Jim Keohane}

Program LoadFont;

Type EightBits=array[0..7] of char;
     EightBytes=array[0..7] of EightBits;
     FontMap=array[128..255] of EightBytes;
     ResFont=array[128..255] of array[0..7] of byte;

Var  Res:^ResFont absolute $0000:$007C; {vector for INT $1F}
     X:ResFont;
     I,J,K,L:Integer;

Const F:FontMap=(
('  XXXX  ',
 ' XX  XX ',
 ' XX     ',
 ' XX  XX ',
 '  XXXX  ',
 '    XX  ',
 '     XX ',
 '  XXXX  '), {128}

('        ',
 ' XX  XX ',
 '        ',
 ' XX  XX ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXXXX',
 '        '), {129}

('    XXX ',
 '        ',
 '  XXXX  ',
 ' XX  XX ',
 ' XXXXXX ',
 ' XX     ',
 '  XXXX  ',
 '        '), {130}

(' XXXXXX ',
 'XX    XX',
 '  XXXX  ',
 '     XX ',
 '  XXXXX ',
 ' XX  XX ',
 '  XXXXXX',
 '        '), {131}

(' XX  XX ',
 '        ',
 '  XXXX  ',
 '     XX ',
 '  XXXXX ',
 ' XX  XX ',
 '  XXXXXX',
 '        '), {132}

(' XXX    ',
 '        ',
 '  XXXX  ',
 '     XX ',
 '  XXXXX ',
 ' XX  XX ',
 '  XXXXXX',
 '        '), {133}

('   XX   ',
 '   XX   ',
 '  XXXX  ',
 '     XX ',
 '  XXXXX ',
 ' XX  XX ',
 '  XXXXXX',
 '        '), {134}

('        ',
 '        ',
 '  XXXX  ',
 ' XX     ',
 ' XX     ',
 '  XXXX  ',
 '     XX ',
 '   XXX  '), {135}

(' XXXXXX ',
 'XX    XX',
 '  XXXX  ',
 ' XX  XX ',
 ' XXXXXX ',
 ' XX     ',
 '  XXXX  ',
 '        '), {136}

(' XX  XX ',
 '        ',
 '  XXXX  ',
 ' XX  XX ',
 ' XXXXXX ',
 ' XX     ',
 '  XXXX  ',
 '        '), {137}

(' XXX    ',
 '        ',
 '  XXXX  ',
 ' XX  XX ',
 ' XXXXXX ',
 ' XX     ',
 '  XXXX  ',
 '        '), {138}

(' XX  XX ',
 '        ',
 '  XXX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '  XXXX  ',
 '        '), {139}

(' XXXXX  ',
 'XX   XX ',
 '  XXX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '  XXXX  ',
 '        '), {140}

(' XXX    ',
 '        ',
 '  XXX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '  XXXX  ',
 '        '), {141}

(' XX   XX',
 '   XXX  ',
 '  XX XX ',
 ' XX   XX',
 ' XXXXXXX',
 ' XX   XX',
 ' XX   XX',
 '        '), {142}

('   XX   ',
 '   XX   ',
 '        ',
 '  XXXX  ',
 ' XX  XX ',
 ' XXXXXX ',
 ' XX  XX ',
 '        '), {143}

('    XXX ',
 '        ',
 ' XXXXXX ',
 '  XX    ',
 '  XXXX  ',
 '  XX    ',
 ' XXXXXX ',
 '        '), {144}

('        ',
 '        ',
 ' XXXXXXX',
 '    XX  ',
 ' XXXXXXX',
 'XX  XX  ',
 ' XXXXXXX',
 '        '), {145}

('   XXXXX',
 '  XX XX ',
 ' XX  XX ',
 ' XXXXXXX',
 ' XX  XX ',
 ' XX  XX ',
 ' XX  XXX',
 '        '), {146}

('  XXXX  ',
 ' XX  XX ',
 '        ',
 '  XXXX  ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXX  ',
 '        '), {147}

('        ',
 ' XX  XX ',
 '        ',
 '  XXXX  ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXX  ',
 '        '), {148}

('        ',
 ' XXX    ',
 '        ',
 '  XXXX  ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXX  ',
 '        '), {149}

('  XXXX  ',
 ' XX  XX ',
 '        ',
 ' XX  XX ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXXXX',
 '        '), {150}

('        ',
 ' XXX    ',
 '        ',
 ' XX  XX ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXXXX',
 '        '), {151}

('        ',
 ' XX  XX ',
 '        ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXXX ',
 '     XX ',
 ' XXXXX  '), {152}

('XX    XX',
 '   XX   ',
 '  XXXX  ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXX  ',
 '   XX   ',
 '        '), {153}

(' XX  XX ',
 '        ',
 ' XX  XX ',
 ' XX  XX ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXX  ',
 '        '), {154}

('   XX   ',
 '   XX   ',
 ' XXXXXX ',
 'XX      ',
 'XX      ',
 ' XXXXXX ',
 '   XX   ',
 '   XX   '), {155}

('   XXX  ',
 '  XX XX ',
 '  XX  X ',
 ' XXXX   ',
 '  XX    ',
 ' XXX  XX',
 ' XXXXXX ',
 '        '), {156}

(' XX  XX ',
 ' XX  XX ',
 '  XXXX  ',
 ' XXXXXX ',
 '   XX   ',
 ' XXXXXX ',
 '   XX   ',
 '   XX   '), {157}

('XXXXX   ',
 'XX  XX  ',
 'XX  XX  ',
 'XXXXX X ',
 'XX   XX ',
 'XX  XXXX',
 'XX   XX ',
 'XX   XXX'), {158}

('    XXX ',
 '   XX XX',
 '   XX   ',
 '  XXXX  ',
 '   XX   ',
 '   XX   ',
 'XX XX   ',
 ' XXX    '), {159}

('    XXX ',
 '        ',
 '  XXXX  ',
 '     XX ',
 '  XXXXX ',
 ' XX  XX ',
 '  XXXXXX',
 '        '), {160}

('   XXX  ',
 '        ',
 '  XXX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '  XXXX  ',
 '        '), {161}

('        ',
 '    XXX ',
 '        ',
 '  XXXX  ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXX  ',
 '        '), {162}

('        ',
 '    XXX ',
 '        ',
 ' XX  XX ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXXXX',
 '        '), {163}

('        ',
 ' XXXXX  ',
 '        ',
 ' XXXXX  ',
 ' XX  XX ',
 ' XX  XX ',
 ' XX  XX ',
 '        '), {164}

(' XXXXXX ',
 '        ',
 ' XX  XX ',
 ' XXX XX ',
 ' XXXXXX ',
 ' XX XXX ',
 ' XX  XX ',
 '        '), {165}

('  XXXX  ',
 ' XX XX  ',
 ' XX XX  ',
 '  XXXXX ',
 '        ',
 ' XXXXXX ',
 '        ',
 '        '), {166}

('  XXX   ',
 ' XX XX  ',
 ' XX XX  ',
 '  XXX   ',
 '        ',
 ' XXXXX  ',
 '        ',
 '        '), {167}

('   XX   ',
 '        ',
 '   XX   ',
 '  XX    ',
 ' XX     ',
 ' XX  XX ',
 '  XXXX  ',
 '        '), {168}

('        ',
 '        ',
 '        ',
 ' XXXXXX ',
 ' XX     ',
 ' XX     ',
 '        ',
 '        '), {169}

('        ',
 '        ',
 '        ',
 ' XXXXXX ',
 '     XX ',
 '     XX ',
 '        ',
 '        '), {170}

('XX    XX',
 'XX   XX ',
 'XX  XX  ',
 'XX XXXX ',
 '  XX  XX',
 ' XX  XX ',
 'XX  XX  ',
 '    XXXX'), {171}

('XX    XX',
 'XX   XX ',
 'XX  XX  ',
 'XX XX XX',
 '  XX XXX',
 ' XX XXXX',
 'XX  XXXX',
 '      XX'), {172}

('   XX   ',
 '   XX   ',
 '        ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '        '), {173}

('        ',
 '  XX  XX',
 ' XX  XX ',
 'XX  XX  ',
 ' XX  XX ',
 '  XX  XX',
 '        ',
 '        '), {174}

('        ',
 'XX  XX  ',
 ' XX  XX ',
 '  XX  XX',
 ' XX  XX ',
 'XX  XX  ',
 '        ',
 '        '), {175}

('  X   X ',
 'X   X   ',
 '  X   X ',
 'X   X   ',
 '  X   X ',
 'X   X   ',
 '  X   X ',
 'X   X   '), {176}

(' X X X X',
 'X X X X ',
 ' X X X X',
 'X X X X ',
 ' X X X X',
 'X X X X ',
 ' X X X X',
 'X X X X '), {177}

('XX XX XX',
 ' XXX XXX',
 'XX XX XX',
 'XXX XXX ',
 'XX XX XX',
 ' XXX XXX',
 'XX XX XX',
 'XXX XXX '), {178}

('   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   '), {179}

('   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 'XXXXX   ',
 '   XX   ',
 '   XX   ',
 '   XX   '), {180}

('   XX   ',
 '   XX   ',
 'XXXXX   ',
 '   XX   ',
 'XXXXX   ',
 '   XX   ',
 '   XX   ',
 '   XX   '), {181}

('  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 'XXXX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {182}

('        ',
 '        ',
 '        ',
 '        ',
 'XXXXXXX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {183}

('        ',
 '        ',
 'XXXXX   ',
 '   XX   ',
 'XXXXX   ',
 '   XX   ',
 '   XX   ',
 '   XX   '), {184}

('  XX XX ',
 '  XX XX ',
 'XXXX XX ',
 '     XX ',
 'XXXX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {185}

('  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {186}

('        ',
 '        ',
 'XXXXXXX ',
 '     XX ',
 'XXXX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {187}

('  XX XX ',
 '  XX XX ',
 'XXXX XX ',
 '     XX ',
 'XXXXXXX ',
 '        ',
 '        ',
 '        '), {188}

('  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 'XXXXXXX ',
 '        ',
 '        ',
 '        '), {189}

('   XX   ',
 '   XX   ',
 'XXXXX   ',
 '   XX   ',
 'XXXXX   ',
 '        ',
 '        ',
 '        '), {190}

('        ',
 '        ',
 '        ',
 '        ',
 'XXXXX   ',
 '   XX   ',
 '   XX   ',
 '   XX   '), {191}

('   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '   XXXXX',
 '        ',
 '        ',
 '        '), {192}

('   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 'XXXXXXXX',
 '        ',
 '        ',
 '        '), {193}

('        ',
 '        ',
 '        ',
 '        ',
 'XXXXXXXX',
 '   XX   ',
 '   XX   ',
 '   XX   '), {194}

('   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '   XXXXX',
 '   XX   ',
 '   XX   ',
 '   XX   '), {195}

('        ',
 '        ',
 '        ',
 '        ',
 'XXXXXXXX',
 '        ',
 '        ',
 '        '), {196}

('   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 'XXXXXXXX',
 '   XX   ',
 '   XX   ',
 '   XX   '), {197}

('   XX   ',
 '   XX   ',
 '   XXXXX',
 '   XX   ',
 '   XXXXX',
 '   XX   ',
 '   XX   ',
 '   XX   '), {198}

('  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XXX',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {199}

('  XX XX ',
 '  XX XX ',
 '  XX XXX',
 '  XX    ',
 '  XXXXXX',
 '        ',
 '        ',
 '        '), {200}

('        ',
 '        ',
 '  XXXXXX',
 '  XX    ',
 '  XX XXX',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {201}

('  XX XX ',
 '  XX XX ',
 'XXXX XXX',
 '        ',
 'XXXXXXXX',
 '        ',
 '        ',
 '        '), {202}

('        ',
 '        ',
 'XXXXXXXX',
 '        ',
 'XXXX XXX',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {203}

('  XX XX ',
 '  XX XX ',
 '  XX XXX',
 '  XX    ',
 '  XX XXX',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {204}

('        ',
 '        ',
 'XXXXXXXX',
 '        ',
 'XXXXXXXX',
 '        ',
 '        ',
 '        '), {205}

('  XX XX ',
 '  XX XX ',
 'XXXX XXX',
 '        ',
 'XXXX XXX',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {206}

('   XX   ',
 '   XX   ',
 'XXXXXXXX',
 '        ',
 'XXXXXXXX',
 '        ',
 '        ',
 '        '), {207}

('  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 'XXXXXXXX',
 '        ',
 '        ',
 '        '), {208}

('        ',
 '        ',
 'XXXXXXXX',
 '        ',
 'XXXXXXXX',
 '   XX   ',
 '   XX   ',
 '   XX   '), {209}

('        ',
 '        ',
 '        ',
 '        ',
 'XXXXXXXX',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {210}

('  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XXXXXX',
 '        ',
 '        ',
 '        '), {211}

('   XX   ',
 '   XX   ',
 '   XXXXX',
 '   XX   ',
 '   XXXXX',
 '        ',
 '        ',
 '        '), {212}

('        ',
 '        ',
 '   XXXXX',
 '   XX   ',
 '   XXXXX',
 '   XX   ',
 '   XX   ',
 '   XX   '), {213}

('        ',
 '        ',
 '        ',
 '        ',
 '  XXXXXX',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {214}

('  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 'XXXXXXXX',
 '  XX XX ',
 '  XX XX ',
 '  XX XX '), {215}

('   XX   ',
 '   XX   ',
 'XXXXXXXX',
 '   XX   ',
 'XXXXXXXX',
 '   XX   ',
 '   XX   ',
 '   XX   '), {216}

('   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 'XXXXX   ',
 '        ',
 '        ',
 '        '), {217}

('        ',
 '        ',
 '        ',
 '        ',
 '   XXXXX',
 '   XX   ',
 '   XX   ',
 '   XX   '), {218}

('XXXXXXXX',
 'XXXXXXXX',
 'XXXXXXXX',
 'XXXXXXXX',
 'XXXXXXXX',
 'XXXXXXXX',
 'XXXXXXXX',
 'XXXXXXXX'), {219}

('        ',
 '        ',
 '        ',
 '        ',
 'XXXXXXXX',
 'XXXXXXXX',
 'XXXXXXXX',
 'XXXXXXXX'), {220}

('XXXX    ',
 'XXXX    ',
 'XXXX    ',
 'XXXX    ',
 'XXXX    ',
 'XXXX    ',
 'XXXX    ',
 'XXXX    '), {221}

('    XXXX',
 '    XXXX',
 '    XXXX',
 '    XXXX',
 '    XXXX',
 '    XXXX',
 '    XXXX',
 '    XXXX'), {222}

('XXXXXXXX',
 'XXXXXXXX',
 'XXXXXXXX',
 'XXXXXXXX',
 '        ',
 '        ',
 '        ',
 '        '), {223}

('        ',
 '        ',
 '  XXX XX',
 ' XX XXX ',
 ' XX  X  ',
 ' XX XXX ',
 '  XXX XX',
 '        '), {224}

('        ',
 '  XXXX  ',
 ' XX  XX ',
 ' XXXXX  ',
 ' XX  XX ',
 ' XXXXX  ',
 ' XX     ',
 ' XX     '), {225}

('        ',
 ' XXXXXX ',
 ' XX  XX ',
 ' XX     ',
 ' XX     ',
 ' XX     ',
 ' XX     ',
 '        '), {226}

('        ',
 ' XXXXXXX',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '  XX XX ',
 '        '), {227}

(' XXXXXX ',
 ' XX  XX ',
 '  XX    ',
 '   XX   ',
 '  XX    ',
 ' XX  XX ',
 ' XXXXXX ',
 '        '), {228}

('        ',
 '        ',
 '  XXXXXX',
 ' XX XX  ',
 ' XX XX  ',
 ' XX XX  ',
 '  XXX   ',
 '        '), {229}

('        ',
 '  XX  XX',
 '  XX  XX',
 '  XX  XX',
 '  XX  XX',
 '  XXXXX ',
 '  XX    ',
 ' XX     '), {230}

('        ',
 '  XXX XX',
 ' XX XXX ',
 '    XX  ',
 '    XX  ',
 '    XX  ',
 '    XX  ',
 '        '), {231}

(' XXXXXX ',
 '   XX   ',
 '  XXXX  ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXX  ',
 '   XX   ',
 ' XXXXXX '), {232}

('   XXX  ',
 '  XX XX ',
 ' XX   XX',
 ' XXXXXXX',
 ' XX   XX',
 '  XX XX ',
 '   XXX  ',
 '        '), {233}

('   XXX  ',
 '  XX XX ',
 ' XX   XX',
 ' XX   XX',
 '  XX XX ',
 '  XX XX ',
 ' XXX XXX',
 '        '), {234}

('    XXX ',
 '   XX   ',
 '    XX  ',
 '  XXXXX ',
 ' XX  XX ',
 ' XX  XX ',
 '  XXXX  ',
 '        '), {235}

('        ',
 '        ',
 ' XXXXXX ',
 'XX XX XX',
 'XX XX XX',
 ' XXXXXX ',
 '        ',
 '        '), {236}

('     XX ',
 '    XX  ',
 ' XXXXXX ',
 'XX XX XX',
 'XX XX XX',
 ' XXXXXX ',
 ' XX     ',
 'XX      '), {237}

('   XXX  ',
 ' XX     ',
 'XX      ',
 'XXXXXX  ',
 'XX      ',
 ' XX     ',
 '   XXX  ',
 '        '), {238}

('  XXXX  ',
 ' XX  XX ',
 ' XX  XX ',
 ' XX  XX ',
 ' XX  XX ',
 ' XX  XX ',
 ' XX  XX ',
 '        '), {239}

('        ',
 ' XXXXXX ',
 '        ',
 ' XXXXXX ',
 '        ',
 ' XXXXXX ',
 '        ',
 '        '), {240}

('   XX   ',
 '   XX   ',
 ' XXXXXX ',
 '   XX   ',
 '   XX   ',
 '        ',
 ' XXXXXX ',
 '        '), {241}

('  XX    ',
 '   XX   ',
 '    XX  ',
 '   XX   ',
 '  XX    ',
 '        ',
 ' XXXXXX ',
 '        '), {242}

('    XX  ',
 '   XX   ',
 '  XX    ',
 '   XX   ',
 '    XX  ',
 '        ',
 ' XXXXXX ',
 '        '), {243}

('    XXX ',
 '   XX XX',
 '   XX XX',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   '), {244}

('   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 '   XX   ',
 'XX XX   ',
 'XX XX   ',
 ' XXX    '), {245}

('   XX   ',
 '   XX   ',
 '        ',
 ' XXXXXX ',
 '        ',
 '   XX   ',
 '   XX   ',
 '        '), {246}

('        ',
 ' XXX XX ',
 'XX XXX  ',
 '        ',
 ' XXX XX ',
 'XX XXX  ',
 '        ',
 '        '), {247}

('  XXX   ',
 ' XX XX  ',
 ' XX XX  ',
 '  XXX   ',
 '        ',
 '        ',
 '        ',
 '        '), {248}

('        ',
 '        ',
 '        ',
 '   XX   ',
 '   XX   ',
 '        ',
 '        ',
 '        '), {249}

('        ',
 '        ',
 '        ',
 '        ',
 '   XX   ',
 '        ',
 '        ',
 '        '), {250}

('    XXXX',
 '    XX  ',
 '    XX  ',
 '    XX  ',
 'XXX XX  ',
 ' XX XX  ',
 '  XXXX  ',
 '   XXX  '), {251}

(' XXXX   ',
 ' XX XX  ',
 ' XX XX  ',
 ' XX XX  ',
 ' XX XX  ',
 '        ',
 '        ',
 '        '), {252}

(' XXX    ',
 '   XX   ',
 '  XX    ',
 ' XX     ',
 ' XXXX   ',
 '        ',
 '        ',
 '        '), {253}

('        ',
 '        ',
 '  XXXX  ',
 '  XXXX  ',
 '  XXXX  ',
 '  XXXX  ',
 '        ',
 '        '), {254}

('        ',
 '        ',
 '        ',
 '        ',
 '        ',
 '        ',
 '        ',
 '        ')); {255}


Begin
 For I:=128 to 255 do
   For J:=0 to 7 do
    begin
     L:=0;
     For K:=0 to 7 do
     If F[I,J,K]<>' ' then L:=L OR ($80 shr K);
     X[I,J]:=L
    End;
  Res:=Ptr(CSEG,$0100);
  Res^:=X;
  InLine($0E/       {push cs}
         $1F/       {pop  ds}
         $BA/$0500/ {mov  dx,1280}
         $CD/$27);  {int  27h}
End.
