{einfacher Textlister von BAPHOMET - verbessert durch DATA WIZARD's Hilfe}

{$A+,B-,D+,E+,F-,I+,L-,N-,O-,R+,S-,V-}
{$M 4048,65536,655360}

Program ReadText;

Uses
  dos,Crt;

Const
  BlackOnLtGray = $70;      LtGrayOnBlue = $17;
  LineLength    = 79;       MaxLines     = 6000;
  ScreenLines   = 22;       escape       = $011b;
  Home          = $4700;    _end         = $4f00;
  upArrow       = $4800;    downArrow    = $5000;
  PageUp        = $4900;    PageDown     = $5100;

Type
  LineStr    = String[Linelength];
  StrPtr     = ^LineStr;

Var
  TxtFile    : Text;
  Lines      : Array[1..MaxLines] of StrPtr;
  NumberLines: 1..MaxLines+1;
  CurrentLine: 1..MaxLines+1-ScreenLines;
  st         : String;
  finished   : Boolean;
  OldExitProc: Pointer;
  TxtBuffer  : Array[0..16383] of Byte;
  OldAttr    : Byte;
  Datei        : ARRAY[1..100] OF STRING[12];
  Anzahl, Waag,
  Senk, Wahl   : INTEGER;

PROCEDURE DateiAuswahl;

VAR   D     : SearchRec;
      Maske : STRING[24];
      Chw,I : INTEGER;
         Ch : CHAR;

PROCEDURE CursorOff;
BEGIN
  GotoXY(1,4);
  Mem[$b800:$01E0]:=32;
  Mem[$b800:$01E1]:=0;
END;

PROCEDURE Invers;
BEGIN
  TextColor(0); TextBackground(15);
  GotoXY(Waag,Senk);
  Write(Datei[Wahl]); CursorOff;
  TextColor(7); TextBackground(0);
END;

PROCEDURE Normal;
BEGIN
  GotoXY(Waag,Senk);
  Write(Datei[Wahl]);
  CursorOff;
END;

PROCEDURE Cursor_Rechts;
BEGIN
  IF (Wahl+1) <= Anzahl THEN BEGIN
    Normal; Inc(Wahl); Inc(Waag,15);
    IF (Waag>64) THEN BEGIN
      Waag:=4; Inc(Senk);
    END;
    Invers;
  END;
END;

PROCEDURE Cursor_Links;
BEGIN
  IF (Wahl-1) > 0 THEN BEGIN
    Normal; Dec(Wahl); Dec(Waag,15);
    IF (Waag<4) THEN BEGIN
      Waag:=64; Dec(Senk);
    END;
    Invers;
  END;
END;

PROCEDURE Cursor_auf;
BEGIN
  IF (Wahl-5) >= 1 THEN BEGIN
    Normal; Dec(Wahl,5);
    Dec(Senk); Invers;
  END;
END;

PROCEDURE Cursor_ab;
BEGIN
  IF (Wahl+5) <= Anzahl THEN BEGIN
    Normal; Inc(Wahl,5);
    Inc(Senk); Invers;
  END;
END;

(* ----------------Prozedur Dateiwahl-------------------- *)
BEGIN
  ClrScr;
  Maske:='*.*';      { In Maske den Suchstring eintragen }
  Anzahl:=0;
  Waag:=4; Senk:=5;    { Mglich: Laufw./Subdirect./Name   }
                       { Beispiel: A:\Daten\*.Dat          }
  FindFirst(Maske,Archive,D);
  IF (DosError <> 0) THEN BEGIN   { Wenn Fehler beim Laden }
    GotoXY(20,12);
    Write(Chr(7), 'Directory oder Datei nicht gefunden');
    CursorOff; Delay(2000); ClrScr;
    Wahl:=0; Exit;
  END;
  WHILE (DosError = 0) AND (Anzahl < 100) DO BEGIN
   if (Pos('.EXE', D.Name) = 0) and
      (pos('.COM', D.Name) = 0) and        { Tadaa! Ich berprfe einfach, }
      (pos('.SYS', D.Name) = 0) then begin { ob der Dateiname die Zeichenfolge}
                                           { .EXE, .COM, oder .SYS enthlt. }
    Inc(Anzahl);
    Datei[Anzahl] := D.Name;
   end;
    FindNext(D);
  END;

  (* --------------Menue auf Bildschirm------------------ *)
  Window(1,1,80,3);
  TextBackground(6); TextColor(0); ClrScr;
  GotoXY(33,2); Write('Dateiauswahl');
  TextColor(7); TextBackground(0);
  Window(1,1,80,25);
  FOR I:=1 TO Anzahl DO BEGIN
    GotoXY(Waag,Senk);
    Write(Datei[I]);
    Inc(Waag,15);
    IF (Waag>68) THEN BEGIN
      Waag := 4; Inc(Senk)
    END;
  END;
  Waag := 4; Senk := 5; Wahl := 1; Invers;

  (* --------------Datei auswhlen----------------------- *)
  REPEAT
    Ch := ReadKey;
    IF (Ch=#0) THEN begin
      Ch:=ReadKey; Chw:=Ord(Ch);
      CASE Chw OF
        77 : Cursor_Rechts;
        75 : Cursor_Links;
        80 : Cursor_ab;
        72 : Cursor_auf;
      END;
    END;
  UNTIL (Ch=#13);
  ClrScr;
END;

Function LastPos(ch : Char; S : String): Byte;
  Var
    x   : Word;
    len : Byte Absolute S;
  begin
    x := succ(len);
    Repeat
      dec(x);
    Until (x = 0) or (S[x] = ch);
    LastPos := x;
  end;  { LastPos }

Function Wrap(Var S,CarryOver: String): String;
  Const
    space = #32;
  Var
    temp      : String;
    LastSpace : Byte;
    len       : Byte Absolute S;
  begin
    FillChar(temp,sizeof(temp),32);
    temp := S; CarryOver := ''; wrap := temp;
    if length(temp) > LineLength then begin
      LastSpace := LastPos(space,copy(temp,1,LineLength+1));
      if LastSpace <> 0 then begin
        Wrap[0]   := chr(LastSpace - 1);
        CarryOver := copy(temp,LastSpace + 1, 255)
      end  { if LastSpace... }
      else begin
        Wrap[0]   := chr(len);
        CarryOver := copy(temp,len,255);
      end; { else }
    end; { if (length(S))...}
  end;  { Wrap }

Function ReadTxtLine(Var f: Text; L: Byte): String;
  Var
    temp : String;
    len  : Byte Absolute temp;
    done : Boolean;
  begin
    len := 0; done := False;
    {$I-}
    While not eoln(f) do begin
      read(f,temp);
      if Ioresult <> 0 then begin
        Writeln('Fehler beim Laden der Datei - abgebrochen!');
        halt;
      end;
    end; { While }
    if eoln(f) then readln(f);
    ReadTxtLine := st + Wrap(temp,st);
    finished := eof(f);
  end;  { ReadTxtLine }

Procedure ReadTxtFile(Var f: Text);
  Var
    x : Word;
  begin
    st          := '';
    NumberLines := 1;
    Repeat
      if NumberLines > MaxLines then begin
        Writeln('Datei zu gro !');
        halt;
      end;
      if (MaxAvail >= Sizeof(LineStr)) then
        new(Lines[NumberLines])
      else begin
        Writeln('Zuwenig Speicher frei !');
        halt;
      end;
      FillChar(Lines[NumberLines]^,LineLength+1,32);
      if length(st) > LineLength then
        Lines[NumberLines]^  := wrap(st,st)
      else if length(st) <> 0 then begin
        Lines[NumberLines]^  := st;
        st := '';
      end else
        Lines[NumberLines]^  := ReadTxtLine(f,LineLength+1);
      Lines[NumberLines]^[0] := chr(LineLength);
      if not finished then
        inc(NumberLines);
    Until finished;
  end;  { ReadTxtFile }

Procedure DisplayScreen(line: Word);
  Var
    x : Byte;
  begin
    GotoXY(1,1);
    For x := 1 to ScreenLines - 1 do
      Writeln(Lines[x-1+line]^);
    Write(Lines[x+line]^)
  end;

Procedure PreviousPage;
  begin
    if CurrentLine > ScreenLines then
      dec(CurrentLine,ScreenLines-1)
    else
      CurrentLine := 1;
  end;  { PreviousPage }

Procedure NextPage;
  begin
    if CurrentLine < (succ(NumberLines) - ScreenLines * 2) then
      inc(CurrentLine,ScreenLines-1)
    else
      CurrentLine := succ(NumberLines) - ScreenLines;
  end;   { NextPage }

Procedure PreviousLine;
  begin
    if CurrentLine > 1 then
      dec(CurrentLine)
    else
      CurrentLine := 1;
  end;  { PreviousLine }

Procedure NextLine;
  begin
    if CurrentLine < (succ(NumberLines) - ScreenLines) then
      inc(CurrentLine)
    else
      CurrentLine := succ(NumberLines) - ScreenLines;
  end; { NextLine }

Procedure StartofFile;
  begin
    CurrentLine := 1;
  end; { StartofFile }

Procedure endofFile;
  begin
    CurrentLine := succ(NumberLines) - ScreenLines;
  end;  { endofFile }

Procedure DisplayFile;

  Function KeyWord : Word; Assembler;
    Asm
      mov  ah,0
      int  16h
    end;

  begin
    DisplayScreen(CurrentLine);
    Repeat
      Case KeyWord of
        PageUp    : PreviousPage;
        PageDown  : NextPage;
        UpArrow   : PreviousLine;
        DownArrow : NextLine;
        Home      : StartofFile;
        _end      : endofFile;
        Escape    : halt;
      end; { Case }
      DisplayScreen(CurrentLine);
    Until False;
  end; { DisplayFile }

Procedure NewExitProc;Far;
  begin
    ExitProc := OldExitProc;
    Window(1,1,80,25);
    TextAttr := OldAttr;
    ClrScr;
  end;

Procedure Initialise;
  begin
    CurrentLine := 1;
    OldAttr := TextAttr;
    assign(TxtFile,datei[wahl]);
    {$I-}  reset(TxtFile);
    if Ioresult <> 0 then begin
      Writeln('Kann Datei nicht ffnen !');
      halt;
    end;
    SetTextBuf(TxtFile,TxtBuffer);
    Window(1,23,80,25);
    Textcolor(Black);
    textbackground(cyan);
    ClrScr;
    Writeln('         Bild , Bild ,  [Cursortaste],  [Cursortaste], Pos1, Ende');
    writeln;
    Write('                                 [Esc] = Quit   ');
    Window(1,1,80,22);
    TextAttr := LtGrayOnBlue;
    ClrScr;
    OldExitProc := ExitProc;
    ExitProc    := @NewExitProc;
  end;

begin
  dateiauswahl;
  Initialise;
  ReadTxtFile(TxtFile);
  DisplayFile;
end.