program polygon;

uses graph,crt,printer;

var cl : array [0..7] of byte;          {Farbe der eingelesenen Pixel}
    sverg,zverg : byte;                 {Vergrerungsfaktoren}
    xdot,ydot : integer;                  {Dotkoordinaten}
    ch : char;

{----------------------------------------------------------------------------}
procedure grinit;
var graphdriver,graphmode : integer;
begin;
    graphmode:=1;
    graphdriver:=9;
    initgraph (graphdriver,graphmode,'E:\BP\BGI');
    setgraphmode (graphmode);
    cleardevice;
end;

{----------------------------------------------------------------------------}
{Muster auf Bildschirm ausgeben}
procedure muster;
var farbe : array [1..15] of string;    {Name der ausgegebenen Farbe}
    xp,yp : integer;                    {Position der Ausgabe}
    i : byte;                           {Schleifenzhler}

begin;
  farbe [1]:='Blue';farbe [2]:='Green';farbe [3]:='Cyan';
  farbe [4]:='Red';farbe [5]:='Magenta';farbe [6]:='Brown';
  farbe [7]:='LightGray';farbe [8]:='DarkGray';farbe [9]:='LightBlue';
  farbe [10]:='LightGreen';farbe [11]:='LigthCyan';farbe [12]:='LightRed';
  farbe [13]:='LigthMagenta';farbe [14]:='Yellow';farbe [15]:='White';

  setcolor (15);
  outtextxy (10,10,' VGA - Hardcopy   *   written by EL Nebuloso in January 1996');
  outtextxy (10,20,' -----------------------------------------------------------');
  xp:=20;yp:=50;
  for i:=1 to 15 do begin;
    setfillstyle (1,i);
    bar (xp,yp,xp+80,yp+50);
    setcolor (15);
    outtextxy (xp,yp+60,farbe [i]);
    xp:=xp+120;
    if xp+120 > 639 then begin;
      xp:=20;
      yp:=yp+80;
    end;
  end;
end;

{----------------------------------------------------------------------------}
{Farbe in Graustufe umwandeln}
function putdot (farbe : byte) : boolean;

begin;
  putdot:=true;
  case farbe of
    0 : putdot:=false;
    1 : if (xdot mod 3 = 0) or (ydot mod 4 = 0) then putdot:=false;
    2 : if (xdot mod 4 = 0) or (ydot mod 3 = 0) then putdot:=false;
    3 : if (xdot mod 2 = 0) or (ydot mod 4 = 0) then putdot:=false;
    4 : if (xdot mod 4 = 0) or (ydot mod 2 = 0) then putdot:=false;
    5 : if (xdot mod 3 = 0) or (ydot mod 2 = 0) then putdot:=false;
    6 : if (xdot mod 2 = 0) or (ydot mod 3 = 0) then putdot:=false;
    7 : if (xdot mod 3 = 0) and (ydot mod 4 = 0) then putdot:=false;
    8 : if (xdot mod 2 = 0) or (ydot mod 2 = 0) then putdot:=false;
    9 : if (xdot mod 4 = 0) and (ydot mod 3 = 0) then putdot:=false;
   10 : if (xdot mod 2 = 0) and (ydot mod 4 = 0) then putdot:=false;
   11 : if (xdot mod 4 = 0) and (ydot mod 2 = 0) then putdot:=false;
   12 : if (xdot mod 3 = 0) and (ydot mod 2 = 0) then putdot:=false;
   13 : if (xdot mod 2 = 0) and (ydot mod 3 = 0) then putdot:=false;
   14 : if (xdot mod 2 = 0) and (ydot mod 2 = 0) then putdot:=false;
 end;
end;

{----------------------------------------------------------------------------}
{Eingelesene Pixel in Bitfolge und ASCII - Code umwandeln und an Drucker senden}
procedure convert;

var wert : integer;                     {Stellenwert fr Binroperationen}
    dest : array [1..4] of string [8];  {Zielbitfolge (Spalte vergrert)}
    index : byte;                       {Nummer der angesprochenen Zielbitfolge}
    output : array [1..4] of byte;      {Codes fr Drucker}
    i,j,k : integer;                    {Schleifenzhler}

begin;
  for i:=1 to sverg do dest [i]:='';

  {Eingelesene Pixel in Bitfolge umwandeln}
  index:=1;
  for j:=1 to 8 do begin;
    if cl [j-1] <> 0 then begin;
      for k:=1 to sverg do begin;
        xdot:=xdot + 1;
        if putdot (cl [j-1]) then dest [index]:=dest [index] + '1';
      end;
    end
    else begin;
      for k:=1 to sverg do dest [index]:=dest [index] + '0';
    end;
      if j mod 2 = 0 then index:=index + 1;
  end;

  {Bitfolge in Codes fr Drucker umwandeln}
  for i:=1 to sverg do begin;
    output [i]:=0;
    wert:=128;
    for j:=1 to 8 do begin;
      if copy (dest [i],j,1) = '1' then output [i]:=output [i] + wert;
      wert:=wert div 2;
    end;
  end;

  {Codes an Drucker weiterleiten}
  for i:=1 to sverg do begin;
    write (lst,chr (output [i]));
  end;

end;

{----------------------------------------------------------------------------}
{Grafikbildschirm auf Drucker ausgeben}
procedure printfunc;
var xstart : integer;                   {Y-Startkoordinate Datenblock}
    xp,yp : integer;                    {Koordinaten der Abtastung}
    zeile,spalte : byte;                {Zeiger fr Tabelle}
    block : byte;                       {Nummer des bermittelten Datenblocks}
    i,j : byte;                         {Schleifenzhler}

begin;
  write (lst,#27+#40+#71+#49+#48+#49);     {Drucker in Grafikmodus versetzen}

  xstart:=639;ydot:=0;
  sverg:=4;zverg:=3;

  for block:=1 to 80 do begin;
    write (lst,#27+#46+#0+#20+#20+#24+#128+#5);    {Druckbefehl geben}

    {Datenblock erstellen}
    for zeile:=0 to 7 do begin;
      xp:=xstart - zeile;

      {Pixel einer Spalte einlesen}
      for i:=1 to zverg do begin;
        ydot:=ydot+1;
        xdot:=0;
        for spalte:=0 to 43 do begin;
          yp:=0 + spalte * 8;
          for j:=0 to 7 do begin;
            cl [j]:=getpixel (xp,yp+j);
          end;
          convert;
        end;
      end;
    end;

    write (lst,#27+#40+#118+#2+#0+#48+#0);         {Zeilenvorschub}
    write (lst,#27+#36+#0+#0);                     {Druckkopf an linken Rand}
    xstart:=xstart - 8;                            {X-Startkoordinate fr neuen Datenblock}
  end;
  write (lst,#27+#64);                             {Grafikmodus deaktivieren}

end;

{----------------------------------------------------------------------------}
begin;
  grinit;
  muster;
  ch:=readkey;
  printfunc;
end.