;----------------------------------------------------------------------------
;
;     ------------------------
;          Coded by        -= IMPORTANT: =-
;              *frank*
;     >  Copyright (c) 1997  <       dedicated to hugi-diskmag!
;     ------------------------
;
;     -->>> mini ADLIB RAW-player <<<--
;
;     Copyright (c) 1995-1997 by Frank Baumgartner aka frank/riot
; 
;     E-mail: frank@itc.or.at
;     Fido: 2:317/11.81
;
;----------------------------------------------------------------------------
;
;
;Notes:         Assemble with TASM 3.2+
;~~~~~~
;
;----------------------------------------------------------------------------
;
; RAW
;
; This format is very simple. It  consists  of  commands  directly sent to OPL
; port. RAW format is used in STARPRT2.EXE intro (for example).
;
;  format:   [0]=db     'RAWADATA'                 ... file identifier
;            [8]=dw     clock                      ... clock (int8) speed
;           [10]=dw     data_size dup (data)       ... adlib data
;           [..]=dw     0ffffh                     ... end of file
;  data: parameter, command.   command==0: data==n ... wait n times.
;                              command==2: data==0 ... set speed (next word)
;                              command==2: data==1 ... set OPL3 port A default
;                              command==2: data==2 ... set OPL3 port B default
;

	.MODEL TINY
	.CODE
	.286
	ORG 100h

raw_type STRUC                          ;RAW-file header

	id      db 8 dup (?)            ;'RAWADATA'
	clock   dw ?
	;dsize  dw X dup(?)
	;data...
	;end: 0ffffh

ENDS


start:                                  ;--- program entry point ---
	push    cs                      ;DS = CS
	pop     ds

	lea     dx, introtext           ;display text...
	mov     ah, 09h
	int     21h

	call    adl_detect              ;auto-detect adlib-card...
	jc      opl3_det

	lea     dx, noadlib             ;display text...
	mov     ah, 09h
	int     21h
	int     20h

opl3_det:                               ;--- opl3 detection ---
	call    opl3_detect
	jnc     fmono

	mov     ah, stereo
	call    opl3_setmode

fmono:
	lea     dx, foundadlib          ;display text...
	mov     ah, 09h
	int     21h

;---- main ----------------------

real_main:
	call    load_raw                ;load raw-file...

	mov     ax, 3508h               ;save old timer-int
	int     21h
	push    es
	push    bx

	mov     ah, 25h                 ;hook in new-timer
	mov     dx, OFFSET raw_timer
	int     21h

	mov     cx, word ptr [rawfile + 8]     ;set timer-freq
	call    set_freq

mainloop:
	mov     ah, 1h                  ;key?
	int     16h
	jz      mainloop

	xor     ah, ah                  ;get key...
	int     16h
	cmp     al, 27                  ;esc?
	jne     mainloop

	mov     ax, 2508h               ;restore old timer-int
	pop     dx
	pop     ds
	int     21h

	xor     cx, cx                  ;restore timer-freq
	call    set_freq

	push    cs                      ;DS = CS
	pop     ds
	call    adl_reset               ;reset adlib
	add     adl_base, 2
	call    adl_reset

	int     20h                     ;back 2 dos...


;----------------------------------------------------------------------------
;
;set_freq, cx = new timer-freq
;
;
set_freq PROC
	cli
	mov     al, 36h                 ;set timer-freq
	out     43h, al
	xchg    ax, cx
	out     40h, al
	xchg    al, ah
	out     40h, al
	sti
	ret
set_freq ENDP


;----------------------------------------------------------------------------
;
;raw_timer:
;
raw_timer PROC
	pusha
	push    ds
	
	push    cs
	pop     ds

	mov     al, count
	test    al, al
	jz      again

	dec     count                   ;timer-delay...
	jnz     idone

again:
	mov     si, songoff
	add     si, offset [rawfile + 10]

	lodsw
	add     songoff, 2

	inc     ax                      ;end of data?
	jnz     okay
	mov     songoff, ax
	jmp     again

okay:
	dec     ax
	xchg    al, ah                  ;ah = param, al = command

	test    al, al                  ;set wait-counter? (command 0)
	jz      set_wait

	cmp     al, 2                   ;other command?
	je      extended

	cmp     al, 0c0h                ;stereo-panning!
	jnae    regok

	cmp     al, 0c0h+9
	jae     regok

	or      ah, opl_pan_left        ;left panning

	test    al, 1                   ;right panning
	jnz     regok
	and     ah, NOT opl_pan_left
	or      ah, opl_pan_right

regok:
	call    adl_write
	jmp     again

set_wait:                               ;set new delay-time
	mov     count, ah

extended:                               ;extended commando
	test    ah, ah
	jnz     idone
	lodsw
	add     songoff, 2
	xchg    ax, cx
	call    set_freq
	jmp     again

idone:
	pop     ds
	mov     al, 20h                 ;EOI
	out     20h, al
	popa
	iret
raw_timer ENDP


;----------------------------------------------------------------------------
;
;load_raw:
;
;load a raw-file into mem...
load_raw PROC

	xor     ax, ax
	mov     si, 80h                 ;prepare command-line
	lodsb
	add     si, ax
	mov     ds:[si], ah

	mov     ax, 3d00h               ;open file
	mov     dx, 82h
	int     21h
	jc      load_error
	xchg    ax, bx

	mov     ah, 3fh                 ;read file...
	mov	cx, 0ffffh - 100h
	sub     cx, OFFSET endmark
	lea     dx, rawfile
	mov	di, dx
	add	di, cx
	int     21h

	mov     ah, 3eh                 ;close file
	int     21h

	mov	ds:[di], 0ffffh

	ret

load_error:                             ;load-error...
	mov     ah, 09h
	lea     dx, load_errmsg
	int     21h
	int     20h
load_raw ENDP

songoff         dw      0
count           db      1
introtext       db      '--> RAW-player, (c) ''97 frank/riot <--', 13, 10, 10, '$'
noadlib         db      'Can''t find Adlib!', 13, 10, '$'
foundadlib      db      'OPL 2/3+ found!', 13, 10, '$'
load_errmsg     db      13, 'Loading-error! (parameter given?)', 13, 10, '$'

INCLUDE adlib.inc                       ;adlib low-level support...

endmark:

;------- ZERO DATA ----------------------------------------------------------

rawfile RAW_type ?                      ;raw-module

;----------------------------------------------------------------------------

	END start

;----------------------------------------------------------------------------

