
;
;
;           Sine/Cosine generator 
;          
; ---------------       Copyright (c) 1997
;                       by Frank Baumgartner.
;   Version 1.00        (aka frank^riot)
;
; * Assemble with TASM v3.2+...
;
; E-mail: frank@itc.or.at, Fido: 2:317/11.81
;
;


	SINCOS_PERIOD   EQU     256             ;set these values

	COS_VALUE       EQU     2146836866      ;as calculated with
	SIN_VALUE       EQU     26350943        ;my "vcalc" - program!


%out     
%out            Sine/Cosine generator v1.00, (c) 1997 by frank^riot 
%out


	DATA SEGMENT

	ALIGN 4

						; sine table 
sine    dd      0, SIN_VALUE
	dd      (SINCOS_PERIOD/4 - 2) dup (?)   ;sin(2*/N) * 2^30

cosine  dd      SINCOS_PERIOD dup (?)


	DATA ENDS


;


	CODE SEGMENT


;
;
;Need to call this function one time at program-
;startup only!
;
;Note: ES must be data-selector!! (= usually DS)
;
;
precalc_sincos PROC

						; sine generator 
	mov     edi, OFFSET sine[4*2]
	mov     ebp, COS_VALUE                  ;cos(2*/N) * 2^31
	mov     eax, sine[4]

	mov     ecx, SINCOS_PERIOD/4 + SINCOS_PERIOD - 2
@@sc_loop:

	imul    ebp
	shrd    eax, edx, 30
	sub     eax, [edi - 8]
	stosd

	loop    @@sc_loop                       ; sine generator end 

	ret
precalc_sincos ENDP


;


	CODE ENDS


