; Programm      : UNQWIN00.ASM
; Funktion      : Mein Vorschlag zum 1. Coding Competition von PAiN.
;                 Eine kleine Windows-Imitation im Mode12h mit Maus.
;                 Diese Version ist 207 Bytes gross.
; Autor         : UniquE
; Datum         : 19.08.1997
; Sprache       : TASM v4.0
; Assemblieren  : TASM /m1 UNQWIN00.ASM
;                 TLINK /TdC UNQWIN00.ASM
                                     
; Voraussetzungen beim Programmstart:
;                             
;   - CS:IP = CS0100h         
;   - CS = DS                 
;   - BX = 00h 
;   - AX = 00h
;   - SP = FFFEh and points to 0000h                              
                                
MODEL           TINY                    ; Tiny program
CODESEG                                 ; One segment 
ORG             100h                    ; CS:0100h as entry-point
                              
Frame           EQU  1d                 ; How fat's the frame?
                                                                 
White           EQU 15d                 ; The White House
Gray            EQU  7d                 ; The mouse is gray...
Blue            EQU  4d                 ; Blue sea.
BlueBack        EQU  1d                 ; Background blue
Black           EQU  0d                 ; The night
                                                         
; ***************************************************************************
; ** The MAIN prog                                                         **
; ***************************************************************************
Start:                                                           
        mov     al, 12h                 ; Init the GFX-mode
        int     10h                                      
                                        
        ; Read out Text in a buffer (for later use)
        mov     ah, 09h                 ; Display String
        lea     dx, MSG                 ; Point at the String
        int     21h                     
                                        
        mov     ah, 0Dh                 ; Read Pixel
        mov     si, Offset Buffer       ; Point at the buffer
        push    si                      ; & Save Buffer Offset to Stack
        mov     cx, 100d                ; Begin at col. xy
   GetPixLoop2:                             
        mov     dx, 15d                 ; Begin at line xy
    GetPixLoop:                             
        dec     cx                      
        int     10h                     ; Read point NOW!
        inc     cx                      
        mov     Byte Ptr [si], al       ; Save this one
        inc     si                      ; Goto next free buffer position
        dec     dx                      ; Goto next pixel
        jnz     GetPixLoop              ; Get them all.
        loop    GetPixLoop2             ; Do all the work
                                        
        ; Draw gray background          
        mov     al, Gray                ; Set colour                        
        xor     si, si                  ; X - maximum in CX
        mov     cl, 80h                 ; Use special function who's putting
                                        ; 02h in CH.       
        mov     dx, 480d                ; Y - maximum      
        call    DrawBlock02             ; Draw the block
                                                           
        ; Draw the white windows
        mov     al, White               ; Set colour
        inc     si                      ; Distance, please. 
        mov     di, 18 * 2              ; Y - maximum is 480 dec - distance
        dec     dx                      ; Decrement the border distance
        mov     cl, 80h - Frame         ; Use special function again       
        call    DrawBlock02             ; X - maximum is 640 dec - distance
                                                                    
        ; Draw the Blue title                                       
        mov     al, BlueBack            ; Blue top                  
        push    si                      ; Frame distance
        pop     di
        mov     dx, 18d + Frame         ; 18 pixel high
        mov     cl, 80h - Frame         ; Use special function again
        call    DrawBlock02             ; Draw the block
                                                   
                                                   
        ; Now, display the text at the right place 
        pop     si                      ; & Get Buffer Offset from Stack
        mov     cl, 100d + 4            ; Begin at col. xy
   SetPixLoop2:                                            
        mov     dl, 15d + 1             ; Begin at line xy
    SetPixLoop:                                            
        mov     al, Byte Ptr [si]       ; Read this one
        cmp     al, 00                  ; Don't paint the background
        je      DontPaint                                  
        mov     al, White               ; Logo - colour is white
        int     10h                     ; Set point NOW!   
      DontPaint:                                           
        inc     si                      ; Goto next buffer position
        dec     dx                      ; Goto next free pixel
        cmp     dl, 01
        jne     SetPixLoop                                 
        dec     cx                                 
        cmp     cl, 05
        jae     SetPixLoop2             ; Do all the work
                       
        ; Draw little gray block                       
        mov     al, Gray                ; Gray colour  
        inc     di                      ; Box limits                             
        mov     dl, 18d                 ; All the limits are defined
        mov     cl, 7Eh                 ; Use special function again
        mov     si, 620d            
        call    DrawBlock02             ; Draw the block   
                                                           
        ; Draw "The small X in the top left corner inside a grey box"
        mov     al, 00h                 ; Put Pixel via BIOS, Black colour

        mov     cl, 070h                ; Define first Col.
        mov     bl, 16d                 ; Start Point
        mov     dl, 04d                                     
                                                            
    XDrawLoop:                                              
        xchg    dl, bl 
        dec     dx                      ; bottom => top     
        int     10h                     ; Put Point NOW!    
        xchg    dl, bl 
        inc     dx                      ; top => bottom     
        int     10h                     ; Put Point NOW!    
        inc     cx                      ; Next col.         
        cmp     cl, 07Bh                ; CX = 635d?
        jne     XDrawLoop               ; Draw all          
                                                            
        ; Mouse control
;        xor     ax, ax                  ; Mouse Reset
;        int     33h
                                                            
        inc     ax                      ; Mouse on (AX = 0001h)
        inc     ax     
        int     33h                                         
                                                            
GetMousPos:                                                 
        mov     al, 03h                 ; Get mouse position
        int     33h                     ; Get mouse position NOW!
        cmp     dx, 18d                 ; Y > 18?          
        ja      GetMousPos              ; Yes => Get Mouse pos.
        cmp     dl, 2d                  ; Y >= 2?
        jb      GetMousPos              ; No => Get Mouse pos.
        cmp     cx, 026Ch               ; X < 620?         
        jb      GetMousPos              ; No => Get Mouse pos.
        cmp     cl, 7Eh                 ; X > 638?
        ja      GetMousPos              ; Yes => Get Mouse pos.
        and     bl, 1                   ; Left button pressed?
        jz      GetMousPos              ; No => Get Mouse pos.
                                                           
                                                           
;       There is already 0003h in AX                           
        int     10h                      ; Back to textmode 03h                  
        ret                              ; Back to DOS
                                                           
; ***************************************************************************
; ** Screen drawing stuff                                                  **
; ***************************************************************************
DrawBlock02:           
        mov     ch, 02h                 ; This part is used 3 times =>1 saved!
                                                           
DrawBlock:                                                 
; Input         :  DX => StartCol                          
;                  CX => StartLine                          
;                  DI => MinCol                            
;                  SI => MinLine                           
        mov     ah, 0Ch                 ; Put Pixel via BIOS
DBLineLoop:                                                
        push    dx                                         
        dec     cx                      ; Move to next line
    DBColLoop:                                             
        dec     dx                      ; Move to next Col.
        int     10h                     ; Put Pixel NOW!   
        cmp     di, dx                  ; All done?        
        jne     DBColLoop               ; Draw the whole line
        pop     dx                                         
        cmp     si, cx                  ; All done?        
        jnae    DBLineLoop              ; Draw all the lines
                                                           
DBExit:                                                    
        ret                             ; RETURN           
                                                           
                                                           
; ***************************************************************************
; ** Strings                                                               **
; ***************************************************************************
MSG     db      "Windows 00", "$"       ; The name of this program
Buffer:                                                    
                                                           
end             Start                   ; Start the program
