#define USELFB 1
#define NOLFB  0

extern unsigned char *LFBadr;
extern unsigned short xres,granul,curbank;


typedef _Packed struct {
   unsigned char signature[4];
   unsigned short version;
   char *oemstr;
   unsigned long capabil;
   unsigned short *videomodeptr;
   unsigned short totalmem;

   unsigned short oemsoftrev;
   char  *oemvendorname;
   char  *oemproductname;
   char  *oemrevptr;
   unsigned char reserved[222];
} vinfo;


typedef _Packed struct {
  unsigned short modeattr;
  unsigned char wina;
  unsigned char winb;
  unsigned short wingranul;
  unsigned short winsize;
  unsigned short winAseg;
  unsigned short winBseg;
  unsigned long winfuncptr;
  unsigned short bytesperline;

  unsigned short Xres;
  unsigned short Yres;
  unsigned char Xcharsize;
  unsigned char Ycharsize;
  unsigned char numberofplanes;
  unsigned char bitsperpix;
  unsigned char numberofbanks;
  unsigned char memorymodel;
  unsigned char banksize;
  unsigned char numberofpages;
  unsigned char _reserved;

  unsigned char redmasksize;
  unsigned char redfieldpos;
  unsigned char greenmasksize;
  unsigned char greenfieldpos;
  unsigned char bluemaskpos;
  unsigned char bluefieldpos;
  unsigned char rsvdmasksize;
  unsigned char rsvdfieldpos;
  unsigned char directcolmodeinfo;

  unsigned long physbaseptr;
  unsigned long offscreenmem;
  unsigned long offscreensize;
  char          __reserved[206];
} vesamodeinfo;


vinfo * get_vesa_info();
char set_svga_mode(short x,short y,char bits,char lfb);
vesamodeinfo * get_mode_info(unsigned short mode);
short search_video_mode(short x,short y,char bits,vinfo *vesa_info);
char set_svga_mode(short x,short y,char bits,char lfb);
void close_svga();

char SetupLFB(unsigned long adress,unsigned long size);
void CloseLFB(unsigned long adres);

void settextmode();
void putpixel(unsigned short x,unsigned short y,unsigned char color,unsigned char *where);

unsigned short convrgb16(short r,short g,short b);
