//ਬ   ": FLOWERS"

#include <conio.h>
#include <math.h>

const double TWO_PI=6.28318530717586477;

unsigned char flowers[256000];
unsigned char screen[64000];

void initflower();
void setgrmode(char x);
void setrgbpalette(char color, char r, char g, char b);
void copyvirtualscreen();
void clearvirtualscreen();
void setcolortable();

void main()
{
  long offset1,offset2,offset3;
  long x,y;
  float time=0;
  initflower();
  setgrmode(0x13);
  setcolortable();
  while(!kbhit())
  {
    clearvirtualscreen();
    x=160+120*sin(time*0.5+1.0);
    y=100+90*cos(time*1.5+2.0);
    offset1=x+(y<<7)+(y<<9);
    x=160+120*sin(time*1.0+1.5);
    y=100+90*cos(time*2.0+0.5);
    offset2=x+(y<<7)+(y<<9);
    x=160+120*sin(time*1.5+2.0);
    y=100+90*cos(time*0.5+1.0);
    offset3=x+(y<<7)+(y<<9);
    for(y=0;y<200;y++)
      for(x=0;x<320;x++)
      {
        screen[x+(y<<6)+(y<<8)]=flowers[x+(y<<7)+(y<<9)+offset1]+
                                flowers[x+(y<<7)+(y<<9)+offset2]+
                                flowers[x+(y<<7)+(y<<9)+offset3];
      }
    time+=0.02;
    copyvirtualscreen();
  }
  getch();
  setgrmode(0x3);
}

void initflower()
{
  for(long y=-200;y<200;y++)
    for(long x=-320;x<320;x++)
      flowers[(x+320)+(y+200)*640]=0.75*cos(16*atan2(y,x))*256/TWO_PI+
                                   1.5*sin(8*atan2(y,x))*256/TWO_PI+
                                   sqrt(x*x+y*y);
}

void setgrmode(char x)
{
  _asm
  {
    xor ax,ax
    mov al,x
    int 10h
  }
}

void setrgbpalette(char color, char r, char g, char b)
{
  _asm
  {
    mov dx,0x3C8
    mov al,color
    out dx,al
    inc dx
    mov al,r
    out dx,al
    mov al,g
    out dx,al
    mov al,b
    out dx,al
  }
}

void setcolortable()
{
  long i=0;
  float c=0;
  while (i<43)
  {
    setrgbpalette(i,63,c,0);
    c+=1.48;
    i++;
  }
  c=0;
  while (i<85)
  {
    setrgbpalette(i,63-c,63,0);
    c+=1.5;
    i++;
  }
  c=0;
  while (i<128)
  {
    setrgbpalette(i,0,63,c);
    c+=1.48;
    i++;
  }
  c=0;
  while (i<171) 
  {
    setrgbpalette(i,0,63-c,63);
    c+=1.48;
    i++;
  }
  c=0;
  while (i<213) 
  {
    setrgbpalette(i,c,0,63);
    c+=1.5;
    i++;
  }
  c=0;
  while (i<256) 
  {
    setrgbpalette(i,63,0,63-c);
    c+=1.48;
    i++;
  }
}

void copyvirtualscreen()
{
  _asm
  {
    mov dx,3DAh
  a:in al,dx
    test al,8
    jnz a
    mov dx,3DAh
  b:in al,dx
    test al,8
    jz b
    cld
    mov edi,0xA0000
    mov esi,offset screen
    mov ecx,16000
    rep movsd
  }
}

void clearvirtualscreen()
{
  _asm
  {
    cld
    mov ecx,16000
    mov edi,offset screen
    mov eax,0x00000000
    rep stosd
  }
}
