//ਬ   ": RADIAL BLUR"
//᫨   ⠢ -  ⨭,  த
//᫥ ᫥⥫쭮 ⢨:   ⠩ 
//-梥 ⨭  PaintBrush, ᠢ   ஬ ⨭,
// ⮬  256-梥,    256 梥 ⨭  ⠢
// intel.bmp.( ⨭ ⢥  ⠢ 320x200,
// bmp`誠    㯠,    祣  )

#include <stdio.h>
#include <conio.h>
#include <math.h>

unsigned char screen[64000];
unsigned char pics[64000];
unsigned char sqr[128000];
long bbx=160,bby=100;
float time=0;

void setgrmode(char x);
void setrgbpalette(char color, char r, char g, char b);
void setcolortable();
void blurscreen();
void blurpics();
void clearvirtualscreen();
void copyvirtualscreen();
void copypicsvirtual();
void readbmp();
void radialblurscreen();
void initsqr();

void main()
{
  setgrmode(0x13);
  initsqr();
  readbmp();
  blurpics();
  setcolortable();
  copypicsvirtual();
  while(!kbhit())
  {
    time+=0.05;
    bbx=160+120*sin(time*1.1+1.5);
    bby=100+90*cos(time*0.8+1.1);
    copypicsvirtual();
    radialblurscreen();
    blurscreen();
    copyvirtualscreen();
  }
  setgrmode(0x3);
  getch();
}

void readbmp()
{
  FILE *in;
  long k=0;
  in=fopen("intel.bmp","rb");
  fseek(in,1078,SEEK_SET);
  for(short y=199;y>=0;y--)
    for(short x=0;x<320;x++)
    {
      char c=fgetc(in);
      if(c==1)pics[x+320*y]=255; else pics[x+320*y]=0;
    }
  fclose(in);
}


void setgrmode(char x)
{
  _asm
  {
    xor ax,ax
    mov al,x
    int 10h
  }
}

void setrgbpalette(char color, char r, char g, char b)
{
  _asm
  {
    mov dx,0x3C8
    mov al,color
    out dx,al
    inc dx
    mov al,r
    out dx,al
    mov al,g
    out dx,al
    mov al,b
    out dx,al
  }
}

void setcolortable()
{
  for(short k=0;k<=255;k++)
    setrgbpalette(k,k/4,k/4,k/4);
}

void clearvirtualscreen()
{
  _asm
  {
    cld
    mov ecx,16000
    mov edi,offset screen
    mov eax,0x00000000
    rep stosd
  }
}

void copypicsvirtual()
{
  _asm
  {
    cld
    mov edi,offset screen
    mov esi,offset pics
    mov ecx,16000
    rep movsd
  }
}

void copyvirtualscreen()
{
  _asm
  {
    mov dx,3DAh
  a:in al,dx
    test al,8
    jnz a
    mov dx,3DAh
  b:in al,dx
    test al,8
    jz b
    cld
    mov edi,0xA0000
    mov esi,offset screen
    mov ecx,16000
    rep movsd
  }
}

void blurpics()
{
  _asm
  {
    mov ecx,0xF780
    mov edi,offset pics
    add edi,320
    xor ebx,ebx
    xor eax,eax
    m1:
    mov al,[edi-320]
    mov bl,[edi-1]
    add ax,bx
    mov bl,[edi+1]
    add ax,bx
    mov bl,[edi+320]
    add ax,bx
    shr ax,2
    mov [edi],al
    inc edi
    loop m1
  }
}

void blurscreen()
{
  _asm
  {
    mov ecx,0xF780
    mov edi,offset screen
    add edi,320
    xor ebx,ebx
    xor eax,eax
    m1:
    mov al,[edi-320]
    mov bl,[edi-1]
    add ax,bx
    mov bl,[edi+1]
    add ax,bx
    mov bl,[edi+320]
    add ax,bx
    shr ax,2
    mov [edi],al
    inc edi
    loop m1
  }
}

void radialblurscreen()
{
  short x,y,vx,vy,px,py,n;
  long s,t;
  long sn=(long)(&screen);
  long tn=(long)(&sqr);
  s=sn+(bbx-1)+((bby-1)<<8)+((bby-1)<<6);
  t=tn;
  for(y=bby-1;y>=0;y--)
  {
    for(x=bbx-1;x>=0;x--)
      {
        vx=*((char*)(t+64000));vy=*((char*)(t));
        short p1=*((char*)(s));
        short p2=*((char*)(s+vx+(vy<<8)+(vy<<6)));
        *((char*)(s))=(p1+p2)>>1;
        s--;
        t++;
      }
    s-=(320-bbx);
    t+=(320-bbx);
  }
  s=sn+(bbx)+((bby-1)<<8)+((bby-1)<<6);
  t=tn;
  for(y=bby-1;y>=0;y--)
  {
    for(x=bbx;x<320;x++)
      {
        vx=*((char*)(t+64000));vy=*((char*)(t));
        short p1=*((char*)(s));
        short p2=*((char*)(s-vx+(vy<<8)+(vy<<6)));
        *((char*)(s))=(p1+p2)>>1;
        s++;
        t++;
      }
    s-=(640-bbx);
    t+=(bbx);
  }
  s=sn+(bbx-1)+((bby)<<8)+((bby)<<6);
  t=tn;
  for(y=bby;y<200;y++)
  {
    for(x=bbx-1;x>=0;x--)
      {
        vx=*((char*)(t+64000));vy=*((char*)(t));
        short p1=*((char*)(s));
        short p2=*((char*)(s+vx-(vy<<8)-(vy<<6)));
        *((char*)(s))=(p1+p2)>>1;
        s--;
        t++;
      }
    s+=(320+bbx);
    t+=(320-bbx);
  }
  s=sn+(bbx)+((bby)<<8)+((bby)<<6);
  t=tn;
  for(y=bby;y<200;y++)
  {
    for(x=bbx;x<320;x++)
      {
        vx=*((char*)(t+64000));vy=*((char*)(t));
        short p1=*((char*)(s));
        short p2=*((char*)(s-vx-(vy<<8)-(vy<<6)));
        *((char*)(s))=(p1+p2)>>1;
        s++;
        t++;
      }
    s+=(bbx);
    t+=(bbx);
  }
}

void initsqr()
{
  short vx,vy;
  float n;
  for(short x=0;x<320;x++)
    for(short y=0;y<200;y++)
    {
        n=(sqrt(x*x+y*y)/8)+1;
        vx=x/n;
        vy=y/n;
        sqr[x+y*320+64000]=vx;
        sqr[x+y*320]=vy;
    }
}
