//ਬ   ":  (C2H5OH)"

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <math.h>

unsigned char buf1[64000];
unsigned char buf2[64000];
unsigned char screen_end[64000];
unsigned char pics[64000];

unsigned char pal[1024];

long buf1_ptr=(long)&buf1;
long buf2_ptr=(long)&buf2;

float time=0;

void setgrmode(char x);
void setrgbpalette(char color, char r, char g, char b);
void setcolortable1();
void setcolortable2();
void copyvirtualscreen1();
void copyvirtualscreen2();
void readbmp();
void waterscreen1();
void waterscreen2();
void waterscreen3();
void setwater();

void main()
{
  setgrmode(0x13);
  readbmp();
  setcolortable1();
  while(!kbhit())
  {
    setwater();
    waterscreen1();
    copyvirtualscreen1();
  }
  getch();
  setcolortable2();
  while(!kbhit())
  {
    setwater();
    waterscreen2();
    copyvirtualscreen2();
  }
  getch();
  while(!kbhit())
  {
    setwater();
    waterscreen3();
    copyvirtualscreen2();
  }
  setgrmode(0x3);
  getch();
}

void readbmp()
{
  char c;
  FILE *in;
  in=fopen("water.bmp","rb");
  fseek(in,54,SEEK_SET);
  for(short x=0;x<256;x++)
  {
    c=fgetc(in);
    pal[(x<<2)]=c>>2;
    c=fgetc(in);
    pal[(x<<2)+1]=c>>2;
    c=fgetc(in);
    pal[(x<<2)+2]=c>>2;
    c=fgetc(in);
  }
  for(short y=199;y>=0;y--)
    for(short x=0;x<320;x++)
    {
      c=fgetc(in);
      pics[x+320*y]=c;
    }
  fclose(in);
}

void setwater()
{
  long s,dx,dy;
  if(buf1_ptr==(long)&buf1)
  {
    s=(rand()<<1)%62000;
    *((long*)(buf1_ptr+s+320)) =0x7FFFFF7F;
    *((long*)(buf1_ptr+s+640)) =0xFFFFFFFF;
    *((long*)(buf1_ptr+s+960)) =0xFFFFFFFF;
    *((long*)(buf1_ptr+s+1280))=0x7FFFFF7F;
    dx=160+120*sin(time*2.5+1.5);
    dy=100+60*cos(time*1.5+2.5);
    s=dx+dy*320;
    *((short*)(buf1_ptr+s+320))=0xFFFF;
    *((short*)(buf1_ptr+s+640))=0xFFFF;
    dx=160+120*sin(time*1.5+2.5);
    dy=100+60*cos(time*2.5+1.5);
    s=dx+dy*320;
    *((short*)(buf1_ptr+s+320))=0xFFFF;
    *((short*)(buf1_ptr+s+640))=0xFFFF;
    time+=0.03;
  }
}

void setgrmode(char x)
{
  _asm
  {
    xor ax,ax
    mov al,x
    int 10h
  }
}

void setrgbpalette(char color, char r, char g, char b)
{
  _asm
  {
    mov dx,0x3C8
    mov al,color
    out dx,al
    inc dx
    mov al,r
    out dx,al
    mov al,g
    out dx,al
    mov al,b
    out dx,al
  }
}

void setcolortable1()
{
  for(short k=0;k<256;k++)
    setrgbpalette(k,k/4,k/4,63);
}

void setcolortable2()
{
  for(short k=0;k<256;k++)
    setrgbpalette(k,pal[(k<<2)+2],pal[(k<<2)+1],pal[(k<<2)]);
}

void copyvirtualscreen1()
{
  _asm
  {
    mov dx,3DAh
  a:in al,dx
    test al,8
    jnz a
    mov dx,3DAh
  b:in al,dx
    test al,8
    jz b
    cld
    mov edi,0xA0000
    mov esi,buf1_ptr
    mov ecx,16000
    rep movsd
  }
}

void copyvirtualscreen2()
{
  _asm
  {
    mov dx,3DAh
  a:in al,dx
    test al,8
    jnz a
    mov dx,3DAh
  b:in al,dx
    test al,8
    jz b
    cld
    mov edi,0xA0000
    mov esi,offset screen_end
    mov ecx,16000
    rep movsd
  }
}

void waterscreen1()
{
  long temp;
  long b1=buf1_ptr+321;
  long b2=buf2_ptr+321;
  for(long k=0;k<63358;k++)
  {
    temp=*((char*)(b1-321));
    temp+=*((char*)(b1-320));
    temp+=*((char*)(b1-319));
    temp+=*((char*)(b1-1));
    temp+=*((char*)(b1+1));
    temp+=*((char*)(b1+319));
    temp+=*((char*)(b1+320));
    temp+=*((char*)(b1+321));
    temp>>=2;
    temp-=*((char*)(b2));
    if(temp<0)temp=0;
    *((char*)(b2))=temp;
    b1++;
    b2++;
  }
  temp=buf1_ptr;
  buf1_ptr=buf2_ptr;
  buf2_ptr=temp;
}


void waterscreen2()
{
  long temp,s;
  long b1=buf1_ptr+321;
  long b2=buf2_ptr+321;
  for(long k=321;k<63679;k++)
  {
    temp=*((char*)(b1-321));
    temp+=*((char*)(b1-320));
    temp+=*((char*)(b1-319));
    temp+=*((char*)(b1-1));
    temp+=*((char*)(b1+1));
    temp+=*((char*)(b1+319));
    temp+=*((char*)(b1+320));
    temp+=*((char*)(b1+321));
    temp>>=2;
    temp-=*((char*)(b2));
    if(temp<0)temp=0;
    *((char*)(b2))=temp;
    b1++;
    b2++;
    temp=temp>>2;
    s=k+temp+(temp<<6)+(temp<<8);
    if(s>63999)s=63999;
    screen_end[k]=pics[s];
  }
  temp=buf2_ptr;
  buf2_ptr=buf1_ptr;
  buf1_ptr=temp;
}

void waterscreen3()
{
  long temp,s,x,x1,x2,y,y1,y2;
  long b1=buf1_ptr+321;
  long b2=buf2_ptr+321;
  for(long k=321;k<63679;k++)
  {
    temp=*((char*)(b1-321));
    y1=*((char*)(b1-320));
    temp+=y1;
    temp+=*((char*)(b1-319));
    x1=*((char*)(b1-1));
    temp+=x1;
    x2=*((char*)(b1+1));
    temp+=x2;
    temp+=*((char*)(b1+319));
    y2=*((char*)(b1+320));
    temp+=y2;
    temp+=*((char*)(b1+321));
    temp>>=2;
    temp-=*((char*)(b2));
    if(temp<0)temp=0;
    *((char*)(b2))=temp;
    b1++;
    b2++;
    x=(x2-x1)>>2;
    y=(y2-y1)>>2;
    s=(k+x+(y<<6)+(y<<8));
    if(s<0)s=0;
    if(s>63999)s=63999;
    screen_end[k]=pics[s];
  }
  temp=buf2_ptr;
  buf2_ptr=buf1_ptr;
  buf1_ptr=temp;
}