<html>
<head>
<title>Bilderarchiv</title>
<meta name="author" content="mados/WildMag">
</head>
<body>

<p>[ <a href="upload.php">Bild hinzufgen</a> |
<a href="admin.php">Administration</a> ]

<?php

//----------------------------------------------------------------------------
// Vollstndiges Einlesen aller Datenstze aus der Datendatei
//----------------------------------------------------------------------------

function db_laden()
{
  //Die globale Variable enthlt das zweidimensionale Array aller Datenstze
  global $bild;

  if ($bild = @file('bilder.txt'))
  {
    for ($i = 0; $i < count($bild); $i++)
    {
      //Datenstze an den Tabulatorpositionen in ihre Elemente zerlegen
      $bild[$i] = explode("\t", chop($bild[$i]));
    }
  }
  else
  {
    //Das Array leeren, falls beim Lesen der Datei ein Fehler aufgetreten ist
    unset($bild);
  }
}

//----------------------------------------------------------------------------
// Darstellen der Liste mit jeweils 10 anklickbaren Vorschaubildern
//----------------------------------------------------------------------------

function bilderarchiv()
{
  global $PHP_SELF, $bild, $seite;

  //Die Nummer des ersten darzustellenden Bildes hngt von der Seitennummer ab
  $erstes = count($bild) - $seite * 10 - 1;

  //Darstellen der Bilder, beginnend mit dem neusten (also von hinten)
  for ($i = $erstes; $i >= max(0, $erstes - 9); $i--)
  {
    //Generierung des Dateinamens der Vorschau aus dem original Dateinamen
    $vorschauname = 'bilder/vorschau/' . preg_replace('/\.\w+/', '.jpg', $bild[$i][0]);

    //Ausgabe des eigentlichen HTML-Codes zum Browser des Anwenders
    echo '<p><a href="' . $PHP_SELF . '?id=' . $i . '">';
    echo '<img src="' . $vorschauname . '" width=' . $bild[$i][3] . ' height=' . $bild[$i][4];
    echo ' alt="' . $bild[$i][5] . '" align=left border=1 hspace=8>';

    echo '<b>' . htmlspecialchars($bild[$i][5]) . '</b></a><br>';
    echo '<small>Autor: ' . htmlspecialchars($bild[$i][7]) . '<br>';
    echo 'Datum: ' . date('d.m.Y', $bild[$i][8]);
    echo '<br clear=all></small>';
  }

  //Darstellung der Links zum seitenweisen Blttern durch das Bilderarchiv
  echo '<p>[ Seite ';
  for ($i = 0; $i < count($bild) / 10; $i++)
  {
    if ($i > 0) echo ' | ';
    if ($i == $seite)
    {
      echo ($i + 1);
    }
    else
    {
      echo '<a href="' . $PHP_SELF . '?seite=' . $i . '">' . ($i + 1) . '</a>';
    }
  }
  echo ' ]';
}

//----------------------------------------------------------------------------
// Anzeigen eines einzelnen Bildes in Originalgre
//----------------------------------------------------------------------------

function details($id)
{
  global $PHP_SELF, $bild, $seite;

  echo '<p><b>' . htmlspecialchars($bild[$id][5]) . '</b><br>';
  echo '<small>Autor: ' . $bild[$id][7] . '<br>';
  echo 'Datum: ' . date('d.m.Y', $bild[$id][8]) . '</small>';

  echo '<p>';
  echo '<img src="bilder/' . $bild[$id][0] . '" width=' . $bild[$id][1] . ' height=' . $bild[$id][2];
  echo ' alt="' . $bild[$id][5] . '" border=1 hspace=8>';

  echo '<p>' . htmlspecialchars($bild[$id][6]);

  echo '<p>[ <a href="' . $PHP_SELF . '?seite=' . $seite . '">Zurck</a> ]';
}

//----------------------------------------------------------------------------
// Beginn des Hauptprogrammes
//----------------------------------------------------------------------------

db_laden();

if ($id >= '0')
{
  //Falls auf ein Vorschaubild geklickt wurde, dieses in Originalgre zeigen
  details($id);
}
else
{
  //Ansonsten die Liste der Vorschaubilder zeigen
  bilderarchiv();
}

?>

</body>
</html>