Program ABi_App_Gen;

Uses  GoldPlay, CRT, DOS;
Const FileName    = 'XX-ABI.APP';
Type  ScreenType  = array [0..3999] of Byte;
Var   DiskFile    : Text;
      ScreenAddr  : ScreenType absolute $B800:$0000;
      OrigMode, I : Word;
      InString    : String[80];


Procedure UnCrunch (var Addr1,Addr2; BlkLen:Integer);
  {UnCrunch (IMAGEDATA,ScreenAddr[ (1*2) + (1*160) -162],IMAGEDATA_LENGTH);}
  Begin
  InLine (
    $1E/               {       PUSH    DS             ;Save data segment.}
    $C5/$B6/ADDR1/     {       LDS     SI,[BP+Addr1]  ;Source Address}
    $C4/$BE/ADDR2/     {       LES     DI,[BP+Addr2]  ;Destination Addr}
    $8B/$8E/BLKLEN/    {       MOV     CX,[BP+BlkLen] ;Length of block}
    $E3/$5B/           {       JCXZ    Done}
    $8B/$D7/           {       MOV     DX,DI          ;Save X coordinate for later.}
    $33/$C0/           {       XOR     AX,AX          ;Set Current attributes.}
    $FC/               {       CLD}
    $AC/               {LOOPA: LODSB                  ;Get next character.}
    $3C/$20/           {       CMP     AL,32          ;If a control character, jump.}
    $72/$05/           {       JC      ForeGround}
    $AB/               {       STOSW                  ;Save letter on screen.}
    $E2/$F8/           {Next:  LOOP    LOOPA}
    $EB/$4C/           {       JMP     Short Done}
                       {ForeGround:}
    $3C/$10/           {       CMP     AL,16          ;If less than 16, then change the}
    $73/$07/           {       JNC     BackGround     ;foreground color.  Otherwise jump.}
    $80/$E4/$F0/       {       AND     AH,0F0H        ;Strip off old foreground.}
    $0A/$E0/           {       OR      AH,AL}
    $EB/$F1/           {       JMP     Next}
                       {BackGround:}
    $3C/$18/           {       CMP     AL,24          ;If less than 24, then change the}
    $74/$13/           {       JZ      NextLine       ;background color.  If exactly 24,}
    $73/$19/           {       JNC     FlashBitToggle ;then jump down to next line.}
    $2C/$10/           {       SUB     AL,16          ;Otherwise jump to multiple output}
    $02/$C0/           {       ADD     AL,AL          ;routines.}
    $02/$C0/           {       ADD     AL,AL}
    $02/$C0/           {       ADD     AL,AL}
    $02/$C0/           {       ADD     AL,AL}
    $80/$E4/$8F/       {       AND     AH,8FH         ;Strip off old background.}
    $0A/$E0/           {       OR      AH,AL}
    $EB/$DA/           {       JMP     Next}
                       {NextLine:}
    $81/$C2/$A0/$00/   {       ADD     DX,160         ;If equal to 24,}
    $8B/$FA/           {       MOV     DI,DX          ;then jump down to}
    $EB/$D2/           {       JMP     Next           ;the next line.}
                       {FlashBitToggle:}
    $3C/$1B/           {       CMP     AL,27          ;Does user want to toggle the blink}
    $72/$07/           {       JC      MultiOutput    ;attribute?}
    $75/$CC/           {       JNZ     Next}
    $80/$F4/$80/       {       XOR     AH,128         ;Done.}
    $EB/$C7/           {       JMP     Next}
                       {MultiOutput:}
    $3C/$19/           {       CMP     AL,25          ;Set Z flag if multi-space output.}
    $8B/$D9/           {       MOV     BX,CX          ;Save main counter.}
    $AC/               {       LODSB                  ;Get count of number of times}
    $8A/$C8/           {       MOV     CL,AL          ;to display character.}
    $B0/$20/           {       MOV     AL,32}
    $74/$02/           {       JZ      StartOutput    ;Jump here if displaying spaces.}
    $AC/               {       LODSB                  ;Otherwise get character to use.}
    $4B/               {       DEC     BX             ;Adjust main counter.}
                       {StartOutput:}
    $32/$ED/           {       XOR     CH,CH}
    $41/               {       INC     CX}
    $F3/$AB/           {       REP STOSW}
    $8B/$CB/           {       MOV     CX,BX}
    $49/               {       DEC     CX             ;Adjust main counter.}
    $E0/$AA/           {       LOOPNZ  LOOPA          ;Loop if anything else to do...}
    $1F);              {Done:  POP     DS             ;Restore data segment.}
  End; {UnCrunch}

Procedure AbiLogo;
  Const IMAGEDATA_WIDTH=80;
        IMAGEDATA_DEPTH=19;
        IMAGEDATA_LENGTH=775;
        IMAGEDATA : array [1..775] of Char = (
     #7,#16,' ', #8,'T','Z','-','i','M','P','','A','B','i','-',' ',#15,
    '','',' ','',#25, #6,'','',#24,#25, #3,'','','',#25, #2,'',
    '','',' ','',' ','','','',#25, #3,'','','','','',#24,#25,
     #3,'','',' ','','','',' ',' ','',' ','',' ','','',' ','',
    ' ',' ','','',' ','','','','',#24,#25, #3,#23,'','',#16,' ',
    ' ','','','',#23,'','',#16,' ',#23,'',#16,' ',#23,'','',#16,
    ' ',#23,'',#16,' ','',' ',#23,'','',#16,'',' ','',#24,#25, #3,
    #23,'','',#16,' ','','','',' ',#23,'','',#16,' ',#23,'',#16,
    ' ',#23,'','',#16,' ',#23,'',#16,'','','','',#23,'',#16,'',
    #23,'',#16,#25, #8, #7,'A','n','s','i',' ','B','u','m',' ','I','n',
    'c','.',#24,#25, #3,#15,#23,'','',#16,' ','','',' ',' ',#23,'',
    '',#16,' ',#23,'',#16,' ',#23,'','',#16,' ',' ','',' ',#23,'',
    #16,'',#23,'',#16,'','','',#24,#25, #3, #7,'',#15,#23,'', #7,
    #16,'',' ',#15,#23,'',#16,' ',' ',#23,'', #7,#16,'',' ','','',
    '',#15,#23,'', #7,#16,'','','','',#15,#23,'', #7,#16,'',#15,
    #23,'', #7,#16,'',' ',#15,#23,'',#16,#25, #7, #7,'W','e',' ','u',
    'p','h','o','l','d',' ','h','i','g','h',' ','s','t','a','n','d','a',
    'r','d','s','.',#24,#25, #4,#15,#23,'','',#16,' ', #7,'','','',
    '',#15,#23,'',#16,' ',' ',#23,'',#16,' ',#23,'','',#16,' ', #7,
    '','','','','',' ',' ','',#25, #7,'R','e','q','u','i','r','e',
    'm','e','n','t','s',' ',':',' ','(','1',')',' ','M','u','s','t',' ',
    'b','e',' ','s','e','m','i','-','d','e','c','e','n','t',#24,#25, #4,
    '',#15,#23,'', #7,#16,'',' ','','','',#15,#23,'', #7,#16,'',
    ' ','','',' ',#15,#23,'','', #7,#16,'','','','',#15,#23,'',
     #7,#16,'','','',#25, #8,'a','t',' ','a','n','s','i','.',' ',' ',
    '(','2',')',' ','M','u','s','t',' ','a','l','w','a','y','s',' ','b',
    'e',' ','"','l','e','f','t',' ','i','n',#24,#25, #4,'','','',' ',
    '',' ',' ','','',' ',' ','','',' ','',' ','',' ',' ','','',
    '','',#25, #8,'t','h','e',' ','d','a','r','k','"','.',#24,#25, #5,
    '','',' ','',#25, #2,'','',#25, #2,'','','',' ',' ','','',
    '',#23,' ',#24,#16,#25, #5, #8,#23,'','', #7,#16,'','',#25, #3,
     #8,#23,'','', #7,#16,'',#25, #2,'','', #8,#23,'','', #7,#16,
    '',' ', #8,#23,'',#24,#16,#25, #5,#23,'','', #7,#16,'',#25, #5,
    '', #8,#23,#26, #5,'', #7,#16,'',' ',' ','','',#24,#15,'','',
     #7,'',#15,'', #7,'','', #8,#23,'', #7,#16,'','',' ',#15,'',
     #7,'','', #8,'','',#25, #2, #7,'','',' ','', #8,#23,'',#16,
    ' ',' ',#23,'',#16,' ','','',' ','','',' ',' ','',#24,#25, #4,
    '',#23,'','',#16,#25,#11,#23,'','',#16,' ','',#23,'',#24,#15,
    #16,'', #7,'',#15,'','',' ', #8,#23,'','',#16,' ',#15,'', #7,
    '','', #8,'','', #7,'','', #8,'','','', #7,'', #8,'',' ',
    '','',' ',#26,#24,'',' ','',' ',' ','','',' ','',' ',' ','',
    '',' ',' ','',#25, #2,'',#24,#25, #3,'',#23,'',#16,'',#24,#25,
     #2,'','','',' ', #7,'Q','u','e','s','t','i','o','n',#24,#15,'',
    ' ', #8,'','',' ',#15,'','', #7,'',#15,'', #7,'','','',#15,
    '', #7,'', #8,'','', #7,'','', #8,'', #7,'', #8,#26,'/','',
    ' ',' ','',' ','','',#25, #2,'',#24);
  Begin
    UnCrunch (IMAGEDATA,ScreenAddr[ (1*2) + (1*160) -162],IMAGEDATA_LENGTH);
  End; {AbiLogo}

Procedure PlayIt;
  {$M 4000,0,40000}                           { Not more heap than needed }
  Begin;
    ClrScr;
    LoadOvl('GoldPlay.ovl');                      { Load the moduleplayer }
    AskInit;	                             { Ask user about sounddevice }
    Initialize;                                   { Initialize the player }
    LoadModule('Nirvana.Mod');                          { Load the module }
      If Error<>0 then
        Begin;
          Writeln('Module Not Found');
          Halt;
        End;
    StartPlaying;                                         { Start Playing }
  End;

Begin
  CheckBreak:=False;
  OrigMode:=LastMode;
  TextMode(Lo(LastMode)+Font8x8);
  ClrScr;
  TextColor(7); Write('Initializing Files...Please Wait...');
  Assign(DiskFile, FileName);
  ReWrite(DiskFile);
  TextColor(15);  Write('Done!');
  PlayIt;
  ClrScr;
  AbiLogo;
  WriteLn(DiskFile,'ABi Member Application');
  WriteLn(DiskFile,'----------------------');

(*  TextColor(7);  GotoXY(2,20);  Write('Handle : ');
  TextColor(3);  ReadLn(InString);
  WriteLn(DiskFile,'Handle : '+InString);

  TextColor(7);  GotoXY(2,21);  Write('Sex (M/F/T) : ');
  TextColor(3);  ReadLn(InString);
  WriteLn(DiskFile,'Sex (M/F/T) : '+InString);

  TextColor(7);  GotoXY(2,22);  Write('}                                 *)

  For I:=64 downto 0 do
    Begin;
      MasterVolume(I);                                   { Fade down .... }
      Delay(10);
    End;
  StopPlaying;                                          { Stop the module }
  DeAlloc;                                            { Remove the module }
  RemoveOvl;	                                { Remove the moduleplayer }

  Readln;
  TextMode(OrigMode);
End.