{ -------------------------------------------------- }
{ %%%%% ( na-mbled: mystic bbs list editor ) %%%%%%% }
{ -------------------------------------------------- }
{ coded for liquid (+o the dominion bbs), since he's }
{ been nice this year :)                             }
{                                        love, santa }
{ -------------------------------------------------- }
{ note: might make an mpl version of this program... }
{ dunno... should make displaying ansi's a breeze... }

{$a+}{$b-}{$d-}{$i-}{$l-}{$r-}
program mbled;
uses crt,dos,ansi;

{$i records.pas}
const
{ declare mbled constants }
  progName = 'mystic bled (bbs list editor)';
  progVers = '0.02 beta 8';
  progDesc = 'manages the mystic internal bbs list data.  even slices and dices!';
  progAuth = '[ne0_akt]';
  bbsLData = 'bbslist.bbi';

var
   bbsRec,
   newbbsRec: bbsListRec;
   bbsLDatF : file of bbsListRec;
   bbsLocID : string[3];
   bbsCType : string;
   dataPath : string[255];
   pathChek : string[1];
   ansiDStr : string[79];
   mbledKey,
   bbsDeltd,
   ansiChar : char;
   loopCoun,
   bbsLFLoc,
   scrnCoor : integer;

{ ansi file template vars }
var
   ansiUseH,
   ansiUseF,
   ansiUseO,
   ansiUseM : boolean;
   ansiHead,
   ansiFoot,
   ansiOpen,
   ansiMove : text;


{ declare proc bodies }

(* added by dream master!DoRE  begin *)

function int2str(number : longint): string;
var tempstr: string;
  begin
    str(number, tempstr);
    int2str := tempstr;
  end;

function addzero(temp : word) : string;
  begin
    if length(int2str(temp)) = 1 then
      addzero := '0' + int2str(temp)
    else
      addzero := int2str(temp);
  end;

function datestr(dosdate : longInt) : string;
var dt : datetime;
  begin
    unpacktime(dosdate, dt);
    datestr := addzero(dt.month) + '/' + addzero(dt.day) + '/' + copy(int2str(dt.year), 3, 2);
  end;

(* added by dream master!DoRE  end *)

procedure draw_openscrn;
  begin
  {$i-}
    assign(ansiOpen,'OPEN.ANS');
    reset(ansiOpen);
    if ioresult <> 0 then ansiUseO := FALSE;
  {$i+}

    if ansiUseO = FALSE then
      begin
        textcolor(15); write(progName + ' ' + progVers + ' by ');
        textcolor(8);  writeln(progAuth);
        textcolor(7);  writeln(progDesc);
        textcolor(8);  writeln('----------------');
        textcolor(7);
      end
    else
      begin
        repeat
          read(ansiOpen,ansiChar);
          display_ansi(ansiChar);
        until eof(ansiOpen);
        ansiChar := readkey;
        close(ansiOpen);
      end
  end;

procedure eval_params;
  begin
    if paramcount = 0  then
      begin
        writeln;
        writeln('path not specified.  using default instead...');
        dataPath := 'c:\mystic\data\';
        delay(800);
      end
    else if paramcount = 1 then
      begin
        pathChek := copy(paramstr(1),length(paramstr(1)),1);
        if pathChek <> pathchar then dataPath := dataPath + pathchar else dataPath := paramstr(1);

        writeln;
        writeln('path set to: ' + dataPath);
        delay(800);
      end
    else if paramcount > 1 then
      begin
        textcolor(15); write(progName + ' ' + progVers + ' by ');
        textcolor(8);  writeln(progAuth);
        textcolor(7);  writeln(progDesc);
        textcolor(8);  writeln('----------------');
        textcolor(7);
        writeln;
        writeln('incorrect syntax.  mbled accepts only one parameter.');
        writeln('program usage:');
        writeln;
        writeln('mbled.exe [full path to your data folder]');
        writeln;
        writeln('ie: mbled.exe c:\mystic\data\');
        writeln;
        writeln('see the mbled documentation for more details');
        halt;
      end;
  end;

procedure draw_header;
  begin
  {$i-}
    assign(ansiHead,'head.ans');
    reset(ansiHead);
    if ioresult <> 0 then ansiUseH := FALSE;
  {$i+}

    if ansiUseH = TRUE then
      begin
        while not (eof(ansiHead)) do
          begin
            read(ansiHead,ansiChar);
            display_ansi(ansiChar);
          end;
        close(ansiHead);
      end
    else
      begin
        fillchar(ansiDStr,sizeof(ansiDStr),'-');
        ansiDStr[0] := #80;
        gotoxy(1,1); textcolor(8); write(ansiDStr);
        gotoxy(1,3); write(ansiDStr);
        fillchar(ansiDStr,sizeof(ansiDStr),'%');
        ansiDStr[0] := #80;
        gotoxy(1,2); textcolor(15); write(ansiDStr);

        gotoxy(5,2); textcolor(7); write('( mbled :: ');
        textcolor(15); write('bbs entry number ');
        str((bbsLFLoc+1),bbsLocID); write(bbsLocID);
        textcolor(7); write(' )');
      end;
  end;

procedure draw_footer;
  begin
  {$i-}
    assign(ansiFoot,'foot.ans');
    reset(ansiFoot);
    if ioresult <> 0 then ansiUseF := FALSE;
  {$i+}

    if ansiUseF = TRUE then
      begin
        while not (eof(ansiFoot)) do
          begin
            read(ansiFoot,ansiChar);
            display_ansi(ansiChar);
          end;

        gotoxy(1,1);
        close(ansiFoot);
      end;
  end;

procedure draw_controls;
  begin
    writeln;
    textcolor(8);  write('{');
    textcolor(15); write('[');
    textcolor(8);  write('}');
    textcolor(7); writeln(' one record backward');

    textcolor(8);  write('{');
    textcolor(15); write(']');
    textcolor(8);  write('}');
    textcolor(7); writeln(' one record forward');

    textcolor(8);  write('{');
    textcolor(15); write('q');
    textcolor(8);  write('}');
    textcolor(7); writeln(' exit m-bled');

    gotoxy(30,20);
    textcolor(8);  write('{');
    textcolor(15); write('n');
    textcolor(8);  write('}');
    textcolor(7); write(' add a blank record');

    gotoxy(30,21);
    textcolor(8);  write('{');
    textcolor(15); write('p');
    textcolor(8);  write('}');
    textcolor(7); write(' purge bbs list');

    gotoxy(30,22);
    textcolor(8);  write('{');
    textcolor(15); write('m');
    textcolor(8);  write('}');
    textcolor(7); write(' move to an entry');
  end;

procedure draw_hotkeys;
  begin
    textcolor(8); gotoxy(1,5); loopCoun := 0;
    for loopCoun := 1 to 9 do
      begin
        writeln('[ ]');
      end;

    textcolor(15); loopCoun := 97; scrnCoor := 5;
    for loopCoun := 97 to 105 do
      begin
        gotoxy(2,scrnCoor);
        write(chr(loopCoun));
        scrnCoor := scrnCoor + 1;
      end;

    gotoxy(1,18); textcolor(8);
    writeln('[ ]');
    gotoxy(2,18); textcolor(15);
    write('j');
  end;

procedure parse_bbslist(var bbsLFLoc : integer);
  begin
    assign(bbsLDatF,dataPath + bbsLData);
    reset(bbsLDatF);

    seek(bbsLDatF,bbsLFLoc);
    read(bbsLDatF,bbsRec);
    newbbsRec := bbsRec;
    draw_hotkeys;

    with bbsRec do
      begin
        { eval connect-type byte }
        case cType of
          1 : bbscType := 'Telnet';
          2 : bbscType := 'Dial-up';
          3 : bbscType := 'Both';
        else
          bbsCType := 'unspecified';
        end;

      textcolor(7); scrnCoor := 5;
        gotoxy(5,scrnCoor); write('board name: ' + BBSName); scrnCoor := scrnCoor + 1;
        gotoxy(5,scrnCoor); write('sysop name: ' + SysopName); scrnCoor := scrnCoor + 1;
        gotoxy(5,scrnCoor); write('software  : ' + Software); scrnCoor := scrnCoor + 1;
        gotoxy(5,scrnCoor); write('location  : ' + Location); scrnCoor := scrnCoor + 1;
        gotoxy(5,scrnCoor); write('conn type : ' + bbsCType); scrnCoor := scrnCoor + 1;
        gotoxy(5,scrnCoor); write('telnet ad : ' + Telnet); scrnCoor := scrnCoor + 1;
        gotoxy(5,scrnCoor); write('phone no. : ' + Phone); scrnCoor := scrnCoor + 1;
        gotoxy(5,scrnCoor); write('baud rate : ' + BaudRate); scrnCoor := scrnCoor + 1;
        gotoxy(5,scrnCoor); writeln('added by  : ' + AddedBy); scrnCoor := scrnCoor + 1;

      textcolor(15); writeln; scrnCoor := scrnCoor + 1;
        writeln('special entry flags/data'); scrnCoor := scrnCoor + 1;
      textcolor(8); writeln('-------'); scrnCoor := scrnCoor + 1;
        gotoxy(5,scrnCoor); textcolor(7); write('verified  : '); write(datestr(Verified)); scrnCoor := scrnCoor + 1;
        gotoxy(5,scrnCoor); textcolor(7); write('deleted   : '); writeln(Deleted);
     end;
    close(bbsLDatF);
  end;

{ declare proc bodies end }
{ declare item editing procs }
procedure save_editdit;
  begin
    assign(bbsLDatF,dataPath + bbsLData);
    reset(bbsLDatF);
      seek(bbsLDatF,bbsLFLoc);
      write(bbsLDatF,newbbsRec);
    close(bbsLDatF);
    clrscr;
      draw_header;
      draw_hotkeys;
      parse_bbslist(bbsLFLoc);
      draw_controls;
      draw_footer;
  end;

procedure addn_newrecd;
var tmpbbsRec : bbsListRec;
    tmpcurTym : DateTime;
    DayOfWeek : word;
  begin
    with tmpcurTym do
      begin
        getdate(Year,Month,Day,DayOfWeek);
      end;

    with tmpbbsRec do
      begin
        cType := 0;
        Phone := '000-000-0000';
        Telnet := 'None';
        BBSName := 'K-Rad PD Board';
        Location := 'Earth';
        SysopName := 'Joe Sysop';
        BaudRate := '9600';
        Software := 'Mystic';
        Deleted := FALSE;
        AddedBy := 'm-BLeD '+progVers;
        packtime(tmpcurTym,Verified);
      end;

    with bbsRec do
      begin
        cType := 0;
        Phone := 'None';
        Telnet := 'None';
        BBSName := 'K-Rad PD Board';
        Location := 'Earth';
        SysopName := 'Joe Sysop';
        BaudRate := 'Telnet';
        Software := 'Mystic';
        Deleted := TRUE;
        AddedBy := 'm-BLeD '+progVers;
        packtime(tmpcurTym,Verified);
      end;

    assign(bbsLDatF,dataPath + bbsLData);
    reset(bbsLDatF);
      seek(bbsLDatF,filesize(bbsLDatF));
      write(bbsLDatF,tmpbbsRec);
      bbsLFLoc := filesize(bbsLDatF) - 1;
    close(bbsLDatF);

    clrscr;
      draw_header;
      draw_hotkeys;
      parse_bbslist(bbsLFLoc);
      draw_controls;
      draw_footer;
  end;

procedure edit_bbsname;
  begin
    gotoxy(17,5); clreol; textbackground(23); textcolor(0);
    write(bbsRec.bbsName); textbackground(16); textcolor(7); clreol; readkey;
    textbackground(16); textcolor(7);

    gotoxy(17,5); clreol;
    gotoxy(17,5); readln(newbbsRec.bbsName);

    if newbbsRec.bbsName = '' then
      begin
        gotoxy(17,5); write(bbsRec.bbsName);
        newbbsRec.bbsName := bbsRec.bbsName;
      end;
    save_editdit;
  end;

procedure edit_sopname;
  begin
    gotoxy(17,6); clreol; textbackground(23); textcolor(0);
      write(bbsRec.sysopName); textbackground(16); textcolor(7); clreol; readkey;
    textbackground(16); textcolor(7);

    gotoxy(17,6); clreol;
    gotoxy(17,6); readln(newbbsRec.sysopName);

    if newbbsRec.bbsName = '' then
      begin
        gotoxy(17,6); write(bbsRec.sysopName);
        newbbsRec.sysopName := bbsRec.sysopName;
      end;
    save_editdit;
  end;

procedure edit_bbssoft;
  begin
    gotoxy(17,7); clreol; textbackground(23); textcolor(0);
      write(bbsRec.software); textbackground(16); textcolor(7); clreol; readkey;
    textbackground(16); textcolor(7);

    gotoxy(17,7); clreol;
    gotoxy(17,7); readln(newbbsRec.software);

    if newbbsRec.software = '' then
      begin
        gotoxy(17,7); write(bbsRec.software);
        newbbsRec.software := bbsRec.software;
      end;
    save_editdit;
  end;

procedure edit_bbsloct;
  begin
    gotoxy(17,8); clreol; textbackground(23); textcolor(0);
      write(bbsRec.location); textbackground(16); textcolor(7); clreol; readkey;
    textbackground(16); textcolor(7);

    gotoxy(17,8); clreol;
    gotoxy(17,8); readln(newbbsRec.location);

    if newbbsRec.location = '' then
      begin
        gotoxy(17,8); write(bbsRec.location);
        newbbsRec.location := bbsRec.location;
      end;
    save_editdit;
  end;

procedure edit_bbsconn;
var boolTmp : boolean;
  begin
    case bbsRec.cType of
      1 : bbscType := 'Telnet';
      2 : bbscType := 'Dial-Up';
      3 : bbscType := 'Both';
    end;

    gotoxy(17,9); clreol; textbackground(23); textcolor(0);
      write(bbscType); textbackground(16); textcolor(7); clreol; readkey;
    textbackground(16); textcolor(7);

    gotoxy(17,9); clreol;
    gotoxy(22,9); textcolor(8); write('1 : telnet  2 : dial-up  3 : both');
    gotoxy(17,9); textcolor(7); readln(newbbsRec.cType);

    case newbbsRec.cType of
      1 : boolTmp := TRUE;
      2 : boolTmp := TRUE;
      3 : boolTmp := TRUE;
    else
      boolTmp := FALSE;
    end;

    if boolTmp = TRUE then
      begin
        case newbbsRec.cType of
          1 : bbscType := 'Telnet';
          2 : bbscType := 'Dial-up';
          3 : bbscType := 'Both';
        else
          bbsCType := 'unspecified';
        end;

        gotoxy(17,9); clreol;
        gotoxy(17,9); write(bbscType);
      end
    else
      begin
        gotoxy(17,9); clreol;
        gotoxy(17,9); write(bbscType);
        newbbsRec.cType := bbsRec.cType;
      end;
    save_editdit;
  end;

procedure edit_telntad;
  begin
    gotoxy(17,10); clreol; textbackground(23); textcolor(0);
      write(bbsRec.telnet); textbackground(16); textcolor(7); clreol; readkey;
    textbackground(16); textcolor(7);

    gotoxy(17,10); clreol;
    gotoxy(17,10); readln(newbbsRec.telnet);

    if newbbsRec.telnet = '' then
      begin
        gotoxy(17,10); write(bbsRec.telnet);
        newbbsRec.telnet := bbsRec.telnet;
      end;
    save_editdit;
  end;

procedure edit_phoneno;
  begin
    gotoxy(17,11); clreol; textbackground(23); textcolor(0);
      write(bbsRec.phone); textbackground(16); textcolor(7); clreol; readkey;
    textbackground(16); textcolor(7);

    gotoxy(17,11); clreol;
    gotoxy(17,11); readln(newbbsRec.phone);

    if newbbsRec.phone = '' then
      begin
        gotoxy(17,11); write(bbsRec.phone);
        newbbsRec.phone := bbsRec.phone;
      end;
    save_editdit;
  end;

procedure edit_baudrat;
  begin
    gotoxy(17,12); clreol; textbackground(23); textcolor(0);
      write(bbsRec.baudRate); textbackground(16); textcolor(7); clreol; readkey;
    textbackground(16); textcolor(7);

    gotoxy(17,12); clreol;
    gotoxy(17,12); readln(newbbsRec.baudRate);

    if newbbsRec.baudRate = '' then
      begin
        gotoxy(17,12); write(bbsRec.baudRate);
        newbbsRec.baudRate := newbbsRec.baudRate;
      end;
    save_editdit;
  end;

procedure edit_addedby;
  begin
    gotoxy(17,13); clreol; textbackground(23); textcolor(0);
      write(bbsRec.addedBy); textbackground(16); textcolor(7); clreol; readkey;
    textbackground(16); textcolor(7);

    gotoxy(17,13); clreol;
    gotoxy(17,13); readln(newbbsRec.addedBy);

    if newbbsRec.addedBy = '' then
      begin
        gotoxy(17,13); write(bbsRec.addedBy);
        newbbsRec.addedBy := bbsRec.addedBy;
      end;
    save_editdit;
  end;

procedure edit_deleted;
  begin
    gotoxy(17,18); clreol; textbackground(23); textcolor(0);
      write(bbsRec.deleted); textbackground(16); textcolor(7); clreol; readkey;
    textbackground(16); textcolor(7);

    gotoxy(17,18); clreol;
    gotoxy(25,18); textcolor(8); write('''Y'' to toggle deleted flag on, ''N'' to toggle it off');
    gotoxy(17,18); textcolor(7);
    bbsDeltd := upcase(readkey);

    case bbsDeltd of
      'Y'  : begin
               newbbsRec.deleted := TRUE;
               gotoxy(17,18); clreol;
               gotoxy(17,18); write(newbbsRec.deleted);
             end;
      'N'  : begin
               newbbsRec.deleted := FALSE;
               gotoxy(17,18); clreol;
               gotoxy(17,18); write(newbbsRec.deleted);
             end;
    else
      gotoxy(17,18); clreol;
      gotoxy(17,18); write(bbsRec.deleted);
      newbbsRec.deleted := bbsRec.deleted;
    end;
    save_editdit;
  end;
{ declare item editing procs end }
{ declare navigation procs }
procedure move_oneforw;
  begin
    assign(bbsLDatF,dataPath + bbsLData);
    reset(bbsLDatF);

    bbsLFLoc := bbsLFLoc + 1;
    if bbsLFLoc >= filesize(bbsLDatF) then
      begin
        gotoxy(1,23); textcolor(15); write('error: reached end of list records'); readkey;
        gotoxy(1,23); clreol; textcolor(7);
        bbsLFLoc := bbsLFLoc - 1;
        close(bbsLDatF);
      end
    else
      begin
        clrscr;
          draw_header;
          draw_hotkeys;
          parse_bbslist(bbsLFLoc);
          draw_controls;
          draw_footer;
      end;
  end;

procedure move_oneback;
  begin
    assign(bbsLDatF,dataPath + bbsLData);
    reset(bbsLDatF);

    bbsLFLoc := bbsLFLoc - 1;
    if bbsLFLoc < 0 then
      begin
        gotoxy(1,23); textcolor(15); write('error: reached end of list records'); readkey;
        gotoxy(1,23); clreol; textcolor(7);
        bbsLFLoc := bbsLFLoc + 1;
        close(bbsLDatF);
      end
    else
      begin
        clrscr;
          draw_header;
          draw_hotkeys;
          parse_bbslist(bbsLFLoc);
          draw_controls;
          draw_footer;
    end;
  end;

procedure jump_torecrd;
var  recMove : integer;
  begin
  {$i-}
    assign(ansiMove,'MOVE.ANS');
    reset(ansiMove);
    if ioresult <> 0 then ansiUseM := FALSE;
  {$i+}

    if ansiUseM = TRUE then
      begin
        while not (eof(ansiMove)) do
          begin
            read(ansiMove,ansiChar);
            display_ansi(ansiChar);
          end;
        close(ansiMove);
      end
    else
      begin
        textbackground(16);
        gotoxy(28,10); textcolor(8); write('');
        gotoxy(28,11); textcolor(8); write(':: '); textcolor(7); write('move to a record '); textcolor(8); write('::');
        gotoxy(28,12); textcolor(8); write(' <            > ');
        gotoxy(28,13); textcolor(8); write(':: '); textcolor(7); write('move to a record '); textcolor(8); write('::');
        gotoxy(28,14); textcolor(8); write('');
          end;

        assign(bbsLDatF,dataPath+bbsLData);
        reset(bbsLDatF);
    repeat
          gotoxy(38,12); read(recMove);
          gotoxy(38,12); write('    ');
          recMove := recMove - 1;
        until recMove <= filesize(bbsLDatF)-1;
    bbsLFLoc := recMove;
    clrscr;
      draw_header;
      draw_hotkeys;
      parse_bbslist(bbsLFLoc);
      draw_controls;
      draw_footer;
  end;
{ declare navigation procs end}
{ declare purging procedures }
var
  bbsODatF : file of bbsListRec;
  recRead  : integer;

function fileexists(fname: string): boolean;
  begin
    fileexists := (fsearch(fname,'') <> '');
  end;

procedure del(fname: string);
var  counter: integer;
     F      : file;
  begin
    if not fileexists(fname) then
      begin
        writeln('Error! Cannot delete ',Fname,'!  File does not actually exist!');
        exit;
      end;
    counter  :=  0;
    assign(f,fname);

    repeat
      {$I-}erase(f);{$I+}
      inc(counter);
      delay(1);
    until ioresult = 0;
 end;

procedure purge_bbslist;
  begin
    clrscr;
    recRead := 0;
    if fileexists(dataPath+'bbslist.bak') then
      begin
        del(dataPath+'bbslist.bak');
        assign(bbsODatF,dataPath+bbsLData);
        rename(bbsODatF,dataPath+'bbslist.bak');
        reset(bbsODatF);
      end
    else
      begin
        assign(bbsODatF,dataPath+bbsLData);
        rename(bbsODatF,dataPath+'bbslist.bak');
        reset(bbsODatF);
      end;

    assign(bbsLDatF,dataPath+bbsLData);
    rewrite(bbsLDatF);

    write('purging bbs list... '); delay(300);

    repeat
      read(bbsODatF,bbsRec);
      if bbsRec.deleted = FALSE then write(bbsLDatF,bbsRec) else inc(recRead);
    until eof(bbsODatF);

    close(bbsODatF);
    close(bbsLDatF);
    if recRead > 0 then bbsLFLoc := bbsLFLoc - recRead;

    write('done!'); delay(1000);

    clrscr;
      draw_header;
      draw_hotkeys;
      parse_bbslist(bbsLFLoc);
      draw_controls;
      draw_footer;
  end;
{ declare purging procedures end }

procedure edit_input(mbledKey : char);
  begin
    case mbledKey of
      'A' : edit_bbsname;
      'B' : edit_sopname;
      'C' : edit_bbssoft;
      'D' : edit_bbsloct;
      'E' : edit_bbsconn;
      'F' : edit_telntad;
      'G' : edit_phoneno;
      'H' : edit_baudrat;
      'I' : edit_addedby;
      'J' : edit_deleted;

      'M' : jump_torecrd;
      'N' : addn_newrecd;
      'P' : purge_bbslist;

      ']' : move_oneforw;
      '[' : move_oneback;
    end;
  end;

begin;
  clrscr;
    ansiUseH := TRUE;
    ansiUseF := TRUE;
    ansiUseO := TRUE;
    ansiUseM := TRUE;

    eval_params;
    draw_openscrn;
    bbsLFLoc := 0;

  clrscr;
    draw_header;
    draw_hotkeys;
    parse_bbslist(bbsLFLoc);
    draw_controls;
    draw_footer;

  repeat
    mbledKey := upcase(readkey);
    edit_input(mbledKey);
    gotoxy(1,1);
  until mbledKey = 'Q';
  textcolor(7); textbackground(16); clrscr;
end.
