#!/bin/sh
#This script was written by Gossamer Axe of Warlock
#gossamer_axe@hotmail.com 
#or telnet to:
# metaledge.darktech.org and leave a comment to sysop

DSLLOG=/root/dsl.log

#change ETH1 to whatever your 2nd ethernet card's ip# is supposed to be
ETH1=192.168.1.102

echo >> $DSLLOG
clear

#kill syslogd which can eat up 98% of your cpu while writing logs

if (/bin/killall syslogd >> /dev/null) then
	echo syslogd successfully killed >> $DSLLOG
	echo syslogd successfully killed
else
	echo syslogd could not be killed >> $DSLLOG
	echo syslogd could not be killed
fi

#we're nicing syslogd so it has the lowest priority to decrease disk
#thrashing

if (/usr/bin/nice -n 19 syslogd >> /dev/null) then
	echo syslogd is playing nice >> $DSLLOG
	echo syslogd is playing nice
else
	echo syslogd isn't nice! >> $DSLLOG
	echo syslogd isn't nice!
fi

#bring up the first ethernet card but assign NO address to it, this is
#to be able to bring up the ppp0 connection

if (/sbin/ifconfig eth0 up >> /dev/null) then
   echo ethernet 0 brought up successfully! >> $DSLLOG
   echo eth0 brought up successfully!
else
   echo ethernet 0 cannot be brought up! >> $DSLLOG
   echo ethernet 0 cannot be brought up!
fi

#start the pppoed daemon, change this to whatever software you use.

if (/usr/sbin/pppoed >> /dev/null) then
   echo pppoed being run now 
else
   echo pppoed wont run!
fi

sleep 10

#make sure ppp is running

if (/sbin/ifconfig | grep 'ppp' >> /dev/null) then
   echo ppp is running!!! >> $DSLLOG
   echo ppp is running!!!
else
   echo unable to start pppoe daemon >> $DSLLOG
   echo unable to start pppoe daemon!!!
fi

#run your firewall, you should have one =]  I run the TrinityOS script
#using ipchains

if (/etc/rc.d/rc.firewall >> /dev/null) then
   echo Firewall enabled >> $DSLLOG
   echo Firewall enabled
else
   echo Firewall error! >> $DSLLOG
   echo Firewall error!
fi

#bring up the 2nd ethernet card for the internal network

if (/sbin/ifconfig eth1 $ETH1 up >> /dev/null) then
   echo eth1 successfully enabled >> $DSLLOG
   echo eth1 successfully enabled
else
   echo eth1 could not be brought up >> $DSLLOG
   echo eth1 could not be brought up
fi

#run bbsip to get our ip# from darktech.org change this to reflect your
#systems setup

if (/usr/local/bin/bbsip >> /dev/null) then
   echo nameserver is running >> $DSLLOG
   echo nameserver is running
else
   echo error running nameserver >> $DSLLOG
   echo error running nameserver
fi

#the reason for the bottom part is that bbsip never grabs my new IP.
#darktech always wants to hang on to my old IP# =[  so I compare my IP
#to the one that's binded to metaledge.darktech.org and if they dont
#match, then it gets run again eventually it gets it right, but i wish
#they'd either write a program for Linux that works or fix the problem
#at the servers end =]

EXTIP=`/sbin/ifconfig ppp0  | awk '/inet addr/ { gsub(".*:", "", $2) ; print $2}'`
echo $EXTIP
NSIP=`/usr/bin/host metaledge.darktech.org | awk '/has address/ {gsub(".address: ", "", $4) ; print $4}'` 
echo $NSIP

if [ "$EXTIP" != "$NSIP" ]; then
/usr/local/bin/bbsip
else
echo IP numbers match! you are good to go!
fi