//ਬ   ": ANIS"

#include <stdio.h>
#include <conio.h>
#include <math.h>

unsigned char screen[64000];
unsigned char texture[65536];
unsigned short anis[64000];
unsigned char pal[1024];

double PI=3.141592653589793;

void setgrmode(char x);
void setrgbpalette(char color, char r, char g, char b);
void setcolortable();
void copyvirtualscreen();
void readbmp();
void initanis();
void renderanis(float time);

void main()
{
  float time=0;
  setgrmode(0x13);
  readbmp();
  initanis();
  setcolortable();
  while(!kbhit())
  {
    renderanis(time);
    copyvirtualscreen();
    time+=0.01;
  }
  getch();
  setgrmode(0x3);
}

void readbmp()
{
  char c;
  FILE *in;
  in=fopen("texture.bmp","rb");
  fseek(in,54,SEEK_SET);
  for(short x=0;x<256;x++)
  {
    c=fgetc(in);
    pal[(x<<2)]=c>>2;
    c=fgetc(in);
    pal[(x<<2)+1]=c>>2;
    c=fgetc(in);
    pal[(x<<2)+2]=c>>2;
    c=fgetc(in);
  }
  for(short y=255;y>=0;y--)
    for(short x=0;x<256;x++)
    {
      c=fgetc(in);
      texture[x+(y<<8)]=c;
    }
  fclose(in);
}

void setgrmode(char x)
{
  _asm
  {
    xor ax,ax
    mov al,x
    int 10h
  }
}

void setrgbpalette(char color, char r, char g, char b)
{
  _asm
  {
    mov dx,0x3C8
    mov al,color
    out dx,al
    inc dx
    mov al,r
    out dx,al
    mov al,g
    out dx,al
    mov al,b
    out dx,al
  }
}

void setcolortable()
{
  for(short k=0;k<256;k++)
    setrgbpalette(k,pal[(k<<2)+2],pal[(k<<2)+1],pal[(k<<2)]);
}

void copyvirtualscreen()
{
  _asm
  {
    mov dx,3DAh
  a:in al,dx
    test al,8
    jnz a
    mov dx,3DAh
  b:in al,dx
    test al,8
    jz b
    cld
    mov edi,0xA0000
    mov esi,offset screen
    mov ecx,16000
    rep movsd
  }
}

void initanis()
{
  long x,y,u,v,p=0;
  double angle, radius;
  for(y=-100;y<100;y++)
    for(x=-160;x<160;x++)
    {
      radius=sqrt(x*x+y*y);
      if(radius<1) radius=1;
      angle=atan2(y,x)+PI;
      v=radius;
      u=angle*128/PI;
      anis[p++]=(u&0xFF)+((v&0xFF)<<8);
    }
}

void renderanis(float time)
{
  long u=256*cos(time);
  long v=512*sin(time);
  long screen_ptr=(long)&screen;
  long i=0;
  for(long k=0;k<64000;k++)
    *((char*)screen_ptr++)=texture[(anis[i++]+u+(v<<8))&0xFFFF];
}