//ਬ   ": "

#include <conio.h>
#include <stdlib.h>

unsigned char screen[64000];
unsigned char buffer[64000];
long screen_ptr=(long)&screen;
long buffer_ptr=(long)&buffer;

void setgrmode(char x);
void setrgbpalette(char color, char r, char g, char b);
void setcolortable();
void trueflamescreen();
void fastflamescreen();
void fastestflamescreen();
void clearvirtualscreen();
void clearbufferscreen();
void copyvirtualscreen();
void copybufferscreen();
void incfire();

main()
{
  setgrmode(0x13);
  setcolortable();
  clearvirtualscreen();
  clearbufferscreen();
  while(!kbhit())
  {
    incfire();
    trueflamescreen();
    copybufferscreen();
    copyvirtualscreen();
  }
  getch();
  while(!kbhit())
  {
    incfire();
    fastflamescreen();
    copyvirtualscreen();
  }
  getch();
  while(!kbhit())
  {
    incfire();
    fastestflamescreen();
    copyvirtualscreen();
  }
  setgrmode(0x3);
  getch();
}

void setgrmode(char x)
{
  _asm
  {
    xor ax,ax
    mov al,x
    int 10h
  }
}

void setrgbpalette(char color, char r, char g, char b)
{
  _asm
  {
    mov dx,0x3C8
    mov al,color
    out dx,al
    inc dx
    mov al,r
    out dx,al
    mov al,g
    out dx,al
    mov al,b
    out dx,al
  }
}


void incfire()
{
  long ptr=screen_ptr+63360;
    for(short x=0;x<320;x+=4)
    {
      char color=rand() % 256;
      long color_long=(color<<24)+(color<<16)+(color<<8)+color;
      *((long*)ptr)=color_long;
      *((long*)(ptr+320))=color_long;
      ptr+=4;
    }
}

void copyvirtualscreen()
{
  _asm
  {
    mov dx,3DAh
  a:in al,dx
    test al,8
    jnz a
    mov dx,3DAh
  b:in al,dx
    test al,8
    jz b
    cld
    mov edi,0xA0000
    mov esi,screen_ptr
    mov ecx,15680
    rep movsd
  }
}

void copybufferscreen()
{
  _asm
  {
    cld
    mov edi,screen_ptr
    mov esi,buffer_ptr
    mov ecx,16000
    rep movsd
  }
}

void clearvirtualscreen()
{
  _asm
  {
    cld
    mov ecx,16000
    mov edi,screen_ptr
    mov eax,0x00000000
    rep stosd
  }
}

void clearbufferscreen()
{
  _asm
  {
    cld
    mov ecx,16000
    mov edi,buffer_ptr
    mov eax,0x00000000
    rep stosd
  }
}

void setcolortable()
{
  for(short k=0;k<=63;k++)
  {
    setrgbpalette(k,k,0,0);
    setrgbpalette(k+64,63,k,0);
    setrgbpalette(k+128,63,63,k);
    setrgbpalette(k+192,63,63,63);
  }
}

void trueflamescreen()
{
  long ptr_scr=screen_ptr+320;
  long ptr_buf=buffer_ptr;
  for(short y=1;y<199;y++)
  {
    for(short x=0;x<320;x++)
    {
      char color=(*((char*)(ptr_scr-321))+*((char*)(ptr_scr-320))+
                  *((char*)(ptr_scr-319))+*((char*)(ptr_scr-1))+
                  *((char*)(ptr_scr+1))+*((char*)(ptr_scr+319))+
                  *((char*)(ptr_scr+320))+*((char*)(ptr_scr+321)))>>3;
      if(color>1) color--; else color=0;
      *((char*)(ptr_buf))=color;
      ptr_scr++;
      ptr_buf++;
    }
  }
}

void fastflamescreen()
{
  long ptr_scr=screen_ptr;
  for(short y=0;y<199;y++)
    for(short x=0;x<320;x++)
    {
      char color=(*((char*)(ptr_scr+319))+*((char*)(ptr_scr+320))+
                  *((char*)(ptr_scr+321))+*((char*)(ptr_scr+640)))>>2;
      if(color>1) color--; else color=0;
      *((char*)ptr_scr)=color;
      ptr_scr++;
    }
}

void fastestflamescreen()
{
  long ptr_scr=screen_ptr;
  for(short y=0;y<197;y+=2)
  {
    for(short x=0;x<320;x++)
    {
      short high=*((char*)(ptr_scr+639))+*((char*)(ptr_scr+640))+
                 *((char*)(ptr_scr+641));
      short low=*((char*)(ptr_scr+1280));
      char pixel=(high+low)>>2;
      if(pixel>2) pixel-=2; else pixel=0;
      *((char*)(ptr_scr))=pixel;
      *((char*)(ptr_scr+320))=(pixel+low)>>1;
      ptr_scr++;
    }
    ptr_scr+=320;
  }
}
