/*************************************************************************************************
*
*	Title:	GDI.cpp
*	Desc:	Provides a GDI based virtual frame buffer interface
*	
*	Note:	1) This is only 32bpp
*			
**************************************************************************************************/

#include <Windows.h>
#include <memory.h>
#include "GDI.h"
#include "Winmain.h"
#include "VVideo.h"

/*************************************************************************************************/
// External Data
/*************************************************************************************************/

/*************************************************************************************************/
// Global Data
/*************************************************************************************************/

/*************************************************************************************************/
// Module Data
/*************************************************************************************************/

static	HWND				m_hWnd;

// our virtual page
static	Color32_t			*m_VPage = NULL;

static	char 				m_bibuf[ sizeof(BITMAPINFOHEADER) + 3*4 ];
static	BITMAPINFO      	&m_bi = *(BITMAPINFO*)&m_bibuf;
static	BITMAPINFOHEADER	&m_bih = m_bi.bmiHeader;

/*************************************************************************************************/
// Functions
/*************************************************************************************************/

/*************************************************************************************************
*
*	Function:	GDI_Open()
*
*	Desc:		Sets up our DIB and Virtaul page
*
*	Notes:		
*
***************************************************************************************************/
int GDI_Open( void )
{
    // create a 32bit color DIB
	memset( &m_bih, 0, sizeof(m_bih) );
    m_bih.biSize = sizeof(m_bih);
    m_bih.biWidth = 320;
    m_bih.biHeight = -240;			// NOTE: -240. this is because DIB's are upside down
    m_bih.biPlanes = 1;
    m_bih.biBitCount = 32;
    m_bih.biCompression = BI_RGB;//BI_BITFIELDS;
    m_bih.biSizeImage = 0;
    m_bih.biXPelsPerMeter = 0;
    m_bih.biYPelsPerMeter = 0;
    m_bih.biClrUsed = 0;
    m_bih.biClrImportant = 0;

	// setup the format our DIB is in

    // 32bit color
    ((unsigned long*)m_bi.bmiColors)[0]=0x00ff0000;
    ((unsigned long*)m_bi.bmiColors)[1]=0x0000ff00;
    ((unsigned long*)m_bi.bmiColors)[2]=0x000000ff;	
	
	// allocate vpage
	m_VPage = (Color32_t *)malloc( 320 * 240 * 4 );
	if (m_VPage == NULL)
	{
		return 1;
	}

	return 0;
}

/*************************************************************************************************
*
*	Function:	GDI_Close()
*
*	Desc:		Releases the Virtual pages memory
*
*	Notes:		
*
***************************************************************************************************/
void GDI_Close( void )
{
	// check we allocated it first
	if (m_VPage)
	{
		free( m_VPage );
	}
}

/*************************************************************************************************
*
*	Function:	GDI_Flip()
*
*	Desc:		Copyies the virtual page to the window
*
*	Notes:		
*
***************************************************************************************************/
void GDI_Flip( void )
{
	RECT client;
	HDC hDC;

	//
	// draw it to our window
	//

	// get the windows Device Contex
	hDC = GetDC( g_hWnd );

	// if its avaliable
	if (hDC != NULL)
	{
		// Get the the window dimentions
		GetClientRect(g_hWnd, &client);

		// Streach it
		StretchDIBits(	hDC, 
						0, 				// Destination top left hand corner X Position
						0, 				// Destination top left hand corner Y Position
						client.right, 	// Destinations Width
						client.bottom, 	// Desitnations height

						0, 				// Source top left hand corner's X Position
						0, 				// Source top left hand corner's Y Position
						320, 			// Sources width
						240,			// Sources height

						m_VPage, 		// Source's data
						&m_bi, 			// Bitmap Info
						DIB_RGB_COLORS, // operations
						SRCCOPY);		

		// now relese the Device Contex.
		ReleaseDC( g_hWnd, hDC );
	}
}

/*************************************************************************************************
*
*	Function:	GDI_GetAddress()
*
*	Desc:		Gets the virtual page's top left hand corners memory address
*
*	Notes:		
*
***************************************************************************************************/
Color32_t *GDI_GetAddress( void )
{
	return m_VPage;
}
