		.386
		Ideal
		Model	Tiny,C

		Include	'vesa.inc'

		CodeSeg

Public		TextInit
Proc		TextInit	uses ax bx cx dx es bp si di
		mov	ax,1130h
		mov	bh,03h
		int	10h
		mov	cx,8*128/2
		mov	si,offset FontBuffer
@@CopyLoop:
		mov	ax,[es:bp]
		mov	[si],ax
		add	bp,2
		add	si,2
		loop	@@CopyLoop

		ret
EndP		TextInit

Public		TextWriteString
Proc		TextWriteString		uses ax bx di si
		arg	strptr:word,bufofs:dword

		mov	edi,[bufofs]
		mov     ebx,edi
		mov	si,[strptr]
		xor	ax,ax
@@Loop1:
		mov	al,[si]
		inc	si
		test	al,al
		jz	@@EndofString
		cmp	al,10
		jne	@@NoEOL
		;add	ebx,320*2*10*2

		xor	eax,eax
		push	ecx
		mov	ax,[VesaModeWidthInBytes]
		mov	ecx,10
		mul	ecx
		pop	ecx
		shl	eax,1		; * 4
		add	ebx,eax

		mov	edi,ebx

		jmp	@@Loop1
@@NoEOL:
		;push	si edi ebx
		pushad
		xor	ah,ah
		call	TextWriteCharacter	C,ax,edi
		popad
		;pop 	ebx edi si
		add	edi,2*8*2*2
		jmp	@@Loop1
@@EndOfString:
		ret
EndP		TextWriteString

; 320*2 16 bit bytes wide
Public		TextWriteCharacter
Proc		TextWriteCharacter
		arg	char:word,bufofs:dword

		mov	si,[char]
		shl	si,3		;*8
		add	si,offset FontBuffer

		mov	ax,0A000h
		mov	es,ax
		mov	edx,[bufofs]
		mov	di,dx
		shr	edx,16
		call	VesaSetBank	C,dx
		mov	cx,16
@@Loop1:
		push	cx
		mov	cx,8
		mov	al,[si]
		mov	ah,80h
@@Loop2:
		test	al,ah
		jz	@@NoPixel
		;xor	ebx,ebx
		mov	ebx,0FFFFFFFFh
		mov	[es:di],ebx
		mov	[es:di+4],ebx
		;mov	[es:di+320*2],ebx
@@NoPixel:
		add	di,8
		test	di,di
		jnz	@@NoBankSwitch
		inc	dx
		call	VesaSetBank	C,dx
@@NoBankSwitch:
		shr	ah,1
		loop	@@loop2
		mov	ax,[VesaModeWidthInBytes]
		sub	ax,8*8
		add	di,ax
		jnc	@@NoBankSwitch2
		inc	dx
		call	VesaSetBank	C,dx
@@NoBankSwitch2:
		pop	cx
		test	cx,1
		jz	@@NoInc
		inc	si
@@NoInc:
		loop	@@Loop1

		ret
EndP		TextWriteCharacter


		DataSeg
FontBuffer	db	8*128 dup(0)
		end





