//split.c by st0ne
//Splits hugi.raw into 3 files (palette, logo, text)

#include <stdio.h>
#define byte unsigned char

//Color differences between (-SHIFT) and (15-SHIFT)
#define SHIFT 10

FILE	*in,*outp,*outl,*outt;
byte	d[3],a[3],b[3];
int    	i,j,k,med;
byte	data[256];

main (int argc, char *argv[]) {
  if (argc==5) {
    in=fopen (argv[1],"rb");
    outp=fopen (argv[2],"wb");
    outl=fopen (argv[3],"wb");
    outt=fopen (argv[4],"wb");
  } else {
    printf ("Usage : split <raw> <pal> <logo> <text>");
    exit(0);
  }

  for(i=0;i<256;i++) data[i]=0;
  b[0]=b[1]=b[2]=i=j=k=0;

  for (j=0; j<256; j++) {
    fread(&d[0],1,1,in);       	//read palette
    fread(&d[1],1,1,in);
    fread(&d[2],1,1,in);
    if ((d[0]!=0)||(d[1]!=0)||(d[2]!=0)||(j==0)) {
      a[0]=d[0];
      a[1]=d[1];
      a[2]=d[2];
      med=0;
      for (i=0;i<3;i++) {      	//compute difference with previous
	d[i]=a[i]-b[i]+SHIFT;
	if (d[i]>200) {
	  a[i]=b[i]-SHIFT;
	  d[i]=0; med=1;	//insert a color
	}
	if (d[i]>15) {
	  a[i]=b[i]+15-SHIFT;
	  d[i]=15; med=1;	//insert a color
	}
      }

      if (j==0) {
	for (i=0;i<3;i++) {     //write new palette
	  b[i]=a[i];
	  fwrite(&j,1,1,outp);
	}
      }
      else {
	for (i=0;i<3;i++) {     //write new palette
	  b[i]=a[i];
	  fwrite(&d[i],1,1,outp);
	}
      }
      data[j]=k++;		//store palette correspondance
      if (med) {       		//do insertion
	fseek(in,-3,SEEK_CUR);
	j--;
	//printf("Insert %d\n",k);
      }
    }
  }

  for (j=0; j<200; j++) {
    for (i=0; i<320; i++) {
      fread(&d[0],1,1,in);     		//read data
      if ((i>=44)&&(i<=268)&&(j>=10)&&(j<=144)) {
	d[0]=data[d[0]];		//new color
	fwrite(&d[0],1,1,outl);		//write hugi
      }
      if ((i>=8)&&(i<=310)&&(j>=153)&&(j<=188)) {
	if (d[0]) d[0]-=248;
	if (!d[0]) d[0]=8;
	d[0]--;
	fwrite(&d[0],1,1,outt);		//write text
      }
    }
  }

  printf ("Split OK : %ld bytes for palette, %ld bytes for logo, %ld bytes for text\n",
    ftell(outp),ftell(outl),ftell(outt));

  exit(0);
  return;
}