;initialize all the other needed things

;init DirectDraw

;in order to avoid problems with incompatible direct draw *.LIBs
;we use run-time loading of DLLs and their functions.
;For doing that we need 2 functions included in the kernel32.dll

		.data

		dllname db "ddraw.dll",0
		functionname db "DirectDrawCreate",0

		.code

	IFDEF masm
	 GetProcAddress equ GetProcAddress@8
	 LoadLibraryA equ LoadLibraryA@4
	ENDIF

		EXTRN LoadLibraryA:near
		EXTRN GetProcAddress:near

		push offset dllname
		call LoadLibraryA
;eax is now the hInstance of the dll (or zero if the function failed)

		push offset functionname
		push eax
		call GetProcAddress

;now we have the adress of the DirectDrawCreate function in eax.
;lets start with creating a DirectDrawInterface

		.data

		DDrawIsInitialized dd 0

;store vtable adresses of DirectDraw interfaces here

		OurDirectDrawInterface   dd 0
		OurPrimarySurface        dd 0
		OurOffscreenSurface      dd 0
		ClipperForPrimarySurface dd 0

		.code

;create a DirectDraw interface
		push 0
		push offset OurDirectDrawInterface
		push 0
		call eax
		or eax,eax
		jnz WM_QUIT_received

;setting up DirectDraw:
;1. set the Cooperative Level. 
;This is done in the COM way of calling functions.
;First, a macro making the conversion easier is established
;NOTE: it uses the EDI register !!!

		DXfunction_ macro interface , method 
		 mov edi,[interface] ;edi = DD-Objekt(adresse)
		 mov edi,[edi]   ;edi = VTable(adresse)
		 mov edi,[edi+method] ; callziel
		  push [interface]
		  call edi
		endm

;this version is extended with code showing errors
;the 3rd and 4th parameter form the text of the
;error message if an error occurs

		DXfunction macro  interface , method , err_interface, err_method
		local noerrmsg , MessageBoxTitle , MessageBoxContent
		 mov edi,[interface] ;edi = DD-Objekt(adresse)
		 mov edi,[edi]   ;edi = VTable(adresse)
		 mov edi,[edi+method] ; callziel
		  push [interface]
		  call edi
		or eax,eax
		jz noerrmsg
		 push MB_ICONHAND + MB_OK
		 push offset MessageBoxTitle
	  	 push offset MessageBoxContent
		 push 0
		 call MessageBoxA
		 jmp WM_QUIT_received

		noerrmsg:

		.data

		MessageBoxTitle db "DirectX Function Call Failed" ,0
		MessageBoxContent db err_interface , " : ", err_method ,0

		.code

		endm


;and now the function call
		push DDSCL_NORMAL
		push 0
		DXfunction OurDirectDrawInterface, DDSETCOOPERATIVELEVEL ,"OurDirectDrawInterface", "DDSETCOOPERATIVELEVEL"

;2. create a primary surface and an offscreen surface

		.data

		SurfaceDescription DDSURFACEDESC <>

		.code

;set up the DDSURFACEDESC structure for telling DirectDraw that a 
;PrimarySurface is needed
		mov dword ptr SurfaceDescription.dwSize, size DDSURFACEDESC
		mov dword ptr SurfaceDescription.ddssurfCaps,DDSCAPS_PRIMARYSURFACE 

		push 0
		push offset OurPrimarySurface
		push offset SurfaceDescription
		DXfunction OurDirectDrawInterface, DDCREATESURFACE, "OurDirectDrawInterface", "DDCREATESURFACE"

;create the offscreen surface according to the primary surface
		mov dword ptr SurfaceDescription.dwSize, size DDSURFACEDESC
		mov dword ptr SurfaceDescription.dwsurfFlags, DDSD_HEIGHT + DDSD_WIDTH + DDSD_CAPS + DDSD_PIXELFORMAT

		push offset SurfaceDescription
		DXfunction OurPrimarySurface, DDSGETCAPS, "OurPrimarySurface", "DDSGETCAPS"

;change settings to our needs so that the offscreen surface fits our needs 
		mov dword ptr SurfaceDescription+DDSURFACEDESC.dwSize, size DDSURFACEDESC
		mov dword ptr SurfaceDescription+DDSURFACEDESC.dwsurfFlags, DDSD_HEIGHT + DDSD_WIDTH + DDSD_CAPS + DDSD_PITCH
		mov dword ptr SurfaceDescription+DDSURFACEDESC.ddssurfCaps, DDSCAPS_OFFSCREENPLAIN  
		mov dword ptr SurfaceDescription+DDSURFACEDESC.dwHeight, 256 
		mov dword ptr SurfaceDescription+DDSURFACEDESC.dwWidth, 256 
		mov dword ptr SurfaceDescription+DDSURFACEDESC.lPitch, 0 

		push 0
		push offset OurOffscreenSurface
		push offset SurfaceDescription
		DXfunction OurDirectDrawInterface, DDCREATESURFACE, "OurDirectDrawInterface", "DDCREATESURFACE"

;create a clipper and set it to the program window

		push 0
		push offset ClipperForPrimarySurface
		push 0
		DXfunction OurDirectDrawInterface, DDCREATECLIPPER, "OurDirectDrawInterface", "DDCREATECLIPPER"

		push [Windowhandle]
		push 0
		DXfunction ClipperForPrimarySurface, DDCSETHWND, "ClipperForPrimarySurface", "DDCSETHWND"
		 push [ClipperForPrimarySurface]
		 DXfunction OurPrimarySurface, DDSSETCLIPPER, "OurPrimarySurface", "DDSSETCLIPPER"

;get the coordinates of our window
		 push offset BlitRect
		 push [Windowhandle]
		 call [GetWindowRect]
	
;Now we have 2 Surfaces (and a clipper). That is all we need here fore drawing.

;initialize DirectSoundCapture

		.data

		dsounddllname db "dsound.dll",0
		dsoundfunctionname db "DirectSoundCaptureCreate",0

;I did not found a useful dsound.inc at all. So the DirectSound settings
;needed are included here, too

		DSCBUFFERDESC equ DSCdwSize
		DSCdwSize        dd 20
		DSCdwFlags       dd 0
		DSCdwBufferBytes dd 1024
		DSCreserved      dd 0
		DSClpwfxFormat   dd 0

		DSCBSTART_LOOPING equ 1
		CREATECAPTUREBUFFER equ 12
		START equ 36
		STOP equ 40

		DSC_WAVEFORMATEX equ DSCwFormatTag
		DSCwFormatTag      dw offset WAVE_FORMAT_PCM
		DSCnChannels       dw 1
		DSCnSamplesPerSec  dd 11025
		DSCnAvgBytesPerSec dd 11025
		DSCnBlockAlign     dw 1
		DSCwBitsPerSample  dw 8
		DSCcbSize          dw 0

		OurDSoundCapture       dd 0
		OurDSoundCaptureBuffer dd 0

		.code

		push offset dsounddllname
		call LoadLibraryA
		push offset dsoundfunctionname
		push eax
		call GetProcAddress

		push 0
		push offset OurDSoundCapture
		push 0
		call eax
		or eax,eax
		jnz WM_QUIT_received

		mov [DSClpwfxFormat], offset DSC_WAVEFORMATEX

;create a capture buffer through the DirectSoundCapture object
		push 0
		push offset OurDSoundCaptureBuffer
		push offset DSCBUFFERDESC
		DXfunction OurDSoundCapture, CREATECAPTUREBUFFER, "OurDSoundCapture", "CREATECAPTUREBUFFER"

;start the recording
		push DSCBSTART_LOOPING
		DXfunction OurDSoundCaptureBuffer, START, "OurDSoundCaptureBuffer", "START"

;set a flag that initialization has finished
		mov [DDrawIsInitialized],1
