#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include "globals.h"
#include "system.h"
#include "text.h"
#include "keys.h"
#include "tunnel.h"

void init_Terrain ()
{
	glEnable (GL_LIGHTING);
	//glDisable (GL_LIGHT1);
	glDisable (GL_BLEND);
	glDisable (GL_TEXTURE_GEN_T);
	glDisable (GL_TEXTURE_GEN_S);
	glFogf (GL_FOG_START, 10.0);
	glFogf (GL_FOG_END, 45.0);
	glEnable (GL_FOG);
	glEnable (GL_DEPTH_TEST);
	GLfloat fogCol[4] = { 0.69f, 0.9f, 0.9f, 1.0f };
	glClearColor (0.69f, 0.9f, 0.9f, 1.0f);
	glFogfv (GL_FOG_COLOR, fogCol);
	glEnable (GL_CULL_FACE);
	glCullFace (GL_BACK);
	glEnable (GL_TEXTURE_2D);

	terrain->textured = true;
	terrain->texture = TID_ATG[4];
	plane->textured = true;
	plane->texture = TID_ATG[5];
	fov = 120;

	for (int i = 0; i < terrain->nVertices; i++)+
		terrain->vertex[i].b = 1.0f - (terrain->vertex[i].y);

	terrain->vertex[797].y -= 0.5f;	// yes, this is a manual tweak

	cam.directional = false;
	cam.tgt[0] = 0;
	cam.tgt[1] = 0;
	cam.tgt[2] = 0;
}

void average (char *data)
{
	int x, y;

	char *tempdata = new char[256*256];
	memset (tempdata, 0, 256*256*sizeof(char));

	for (x = 1; x < 255; x++)
	{
		for (y = 1; y < 255; y++)
		{
			char p[8];

			p[0] = data[256*(y-1)+x-1];
			p[1] = data[256*(y-1)+x];
			p[2] = data[256*(y-1)+x+1];
			p[3] = data[256*(y)  +x-1];
			p[4] = data[256*(y)  +x+1];
			p[5] = data[256*(y+1)+x-1];
			p[6] = data[256*(y+1)+x];
			p[7] = data[256*(y+1)+x+1];

			tempdata[256*y+x] = ((	p[0] + p[1] +
									p[2] + p[3] +
									p[4] + p[5] +
									p[6] + p[7]) / 8);
		}
	}

	memcpy (data, tempdata, 256*256*sizeof(char));
	delete tempdata;
}

void genTerrainData (char *data)
{
	int x, y;

	memset (data, 0, 256*256*sizeof(char));

	for (x = 0; x < 256; x++)
	{
		for (y = 0; y < 256; y++)
		{
			data[256*y+x] = (char)(rand () % 128 - 64 + (sin(x/16.0f)*50 + cos(y/16.0f)*50));
		}
	}

	for (x = 0; x < 6; x++)
		average (data);
}

void breakingthewaves ()
{
	for (int i = 0; i < plane->nVertices; i++)
	{
		plane->vertex[i].y = (GLfloat)(cos (plane->vertex[i].x + time*5)*0.17 + sin (plane->vertex[i].z/4.0f+time*6)*0.12);
	}
} 





void part_Terrainpart ()
{
	static bool first = true;

	static float starttime = time;
	static float lasttime = 0, previoustime = 123;
	static float fa = 0.0;
	static int lastrow = -1;
	static currectcam = 0;

	float lapsedtime = time - starttime;
	float delta = lapsedtime - lasttime;

	if (first)
	{
		init_Terrain ();
		first = false;
	}
/*
	if (lapsedtime < 1)
	{
		fadeterrain(fa);
		
		fa = delta;// * 0.5;
	}
/*
	if (lapsedtime < 1)
	{
		fadeterrain(fa);
		
		fa = delta;// * 0.5;
	}
*/

	if (currectcam == 0)
		{
		cam.pos[0] = (GLfloat)(cos(time*0.16) * 25 + 3);
		cam.pos[1] = 5;
		cam.pos[2] = (GLfloat)(sin(time*0.32) * 25 + 2);
		}
	else if (currectcam == 1)
		{
		cam.pos[0] = (GLfloat)(cos(-time*0.16) * 5 + 3);
		cam.pos[1] = 10;
		cam.pos[2] = (GLfloat)(sin(-time*0.32) * 5 + 2);
		}
	else if (currectcam == 2)
		{
		cam.pos[0] = (GLfloat)(cos(time*0.56) * 25 + 3);
		cam.pos[1] = 10;
		cam.pos[2] = (GLfloat)(sin(time*0.32) * 25 + 2);
		}
	else if (currectcam == 3)
		{
		cam.pos[0] = (GLfloat)(cos(-time*0.11) * 1 + 1);
		cam.pos[1] = 12;
		cam.pos[2] = (GLfloat)(sin(-time*0.55) * 1 + 1);
		}
	
	
	
	
	GLfloat lightPos0[4] = {cam.pos[0], cam.pos[1], cam.pos[2], 1.0f };
	glLightfv (GL_LIGHT0, GL_POSITION, lightPos0);
	SetProjection ();

	plane->pY = -1.4f;

	terrain->render ();
	glEnable (GL_BLEND);
	plane->render ();
	glDisable (GL_BLEND);

	breakingthewaves();
/*
	if (lapsedtime < 1)
	{
		fa = delta;// * 0.5;
		ledsensmiley (0.0,0.0,0.0,1.0-fa);
	} */


if (order == 10)
  for (int j=0;j<64;j+=16)
	{
	if (row >= 0+j && row < 4+j)
		{
		if (row == 0+j && lastrow != 0+j)
			{
			previoustime = time;
			lastrow = 0+j;
			currectcam = j/16;
			}

		if ( (fa = ((time - previoustime)*2)) > 1.0)
			fa = 1.0;
		else if (fa < 0.0)
			fa = 0.0;

		if (fa != 1.0)
		    ledsensmiley (0.0,0.0,0.0,1.0-fa);

		break;
		}
	else if (row >= 12+j && row < 16+j)
		{
		if (row == 12+j && lastrow != 12+j)
			{
			previoustime = time;
			lastrow = 12+j;
			}

		if ( (fa = ((time - previoustime)*2)) > 1.0)
			fa = 1.0;
		else if (fa < 0.0)
			fa = 0.0;

		if (fa != 0.0)
		    ledsensmiley (0.0,0.0,0.0,fa);
		
		break;
		}
	}
else
	{
	currectcam = 0;	
      if (row >= 0 && row < 4)
		{
		if (row == 0 && lastrow != 0)
			{
			previoustime = time;
			lastrow = 0;
			}

		if ( (fa = ((time - previoustime)*2)) > 1.0)
			fa = 1.0;
		else if (fa < 0.0)
			fa = 0.0;

		if (fa != 1.0)
		    ledsensmiley (0.0,0.0,0.0,1.0-fa);
		}
	  else if (row >= 60 && row < 64)
		{
		if (row == 60 && lastrow != 60)
			{
			previoustime = time;
			lastrow = 60;
			}

		if ( (fa = ((time - previoustime)*2)) > 1.0)
			fa = 1.0;
		else if (fa < 0.0)
			fa = 0.0;

		if (fa != 0.0)
		    ledsensmiley (0.0,0.0,0.0,fa);
	
		}
	}

}
