#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include "system.h"
#include "globals.h"
#include "model.h"
#include "objgen.h"
#include "text.h"

void init_Wave ()
{
	GLfloat fogCol[4] = { 0.0f, 0.0f, 0.0f, 1.0f };
	glClearColor (0.0f, 0.0f, 0.0f, 1.0f);
	glFogfv (GL_FOG_COLOR, fogCol);
	cam.directional = false;
	cam.pos[0] = 0;
	cam.pos[1] = 80;
	cam.pos[2] = 80;
	cam.tgt[0] = 0;
	cam.tgt[1] = 80;
	cam.tgt[2] = 0;
	fov = 100;
	glEnable (GL_BLEND);
	glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); 
	glDisable (GL_TEXTURE_2D);
	glDisable (GL_LIGHTING);
	glEnable (GL_BLEND);
	glCullFace(GL_BACK);
	glFogf (GL_FOG_START, 0.0);
	glFogf (GL_FOG_END, 350.0);
	cube->textured = false;
	for (int i = 0; i < cube->nVertices; i ++)
		cube->vertex[i].a = 0.5f;
}

void Draw2DImage (int id, GLfloat x, GLfloat y, GLfloat z, GLfloat a)
{
	glPushAttrib (GL_ALL_ATTRIB_BITS);
	glPushMatrix ();
		glTranslatef (x, y, z);
		glEnable (GL_TEXTURE_2D);
		glBindTexture (GL_TEXTURE_2D, id);
		glEnable (GL_BLEND);
		glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glDisable (GL_TEXTURE_GEN_S);
		glDisable (GL_TEXTURE_GEN_T);
		glDisable (GL_LIGHTING);
		glDisable (GL_FOG);
		glRotatef (cos(time)*20, -0.3, 0.7, 0);
		glBegin (GL_QUADS);
			glColor4f (1.0f, 1.0f, 1.0f, a); glTexCoord2f (0.0f, 1.0f); glVertex3f (-1.0f, -1.0f,  0.0f);
			glColor4f (1.0f, 1.0f, 1.0f, a); glTexCoord2f (1.0f, 1.0f); glVertex3f ( 1.0f, -1.0f,  0.0f);
			glColor4f (1.0f, 1.0f, 1.0f, a); glTexCoord2f (1.0f, 0.0f); glVertex3f ( 1.0f,  1.0f,  0.0f);
			glColor4f (1.0f, 1.0f, 1.0f, a); glTexCoord2f (0.0f, 0.0f); glVertex3f (-1.0f,  1.0f,  0.0f);
		glEnd ();
	glPopMatrix ();
	glPopAttrib ();
}

void part_Wavepart ()
{
	static bool first = true;
	static float starttime = time;
	static float lasttime = 0;
	static bool stopped[18*30][4];
	static GLfloat lineA = 0.0f;
	float	WAVESIZE = 4.0;
	char index[4] = { 2, 3, 6, 7 };
	float lapsedtime = time - starttime;
	float delta = time - lasttime;
	float x, z;
	int i;

	if (first)
	{
		init_Wave ();
		for (i = 0; i < 18*30; i++)
			stopped[i][0] = stopped[i][1] = stopped[i][2] = stopped[i][3] = false;

		first = false;
	}

	SetProjection ();

	GLfloat sf = 1.0f;
	if (order == 1 && row < 10)
	{
		sf = (time - starttime) * 0.8;
		if (sf > 1.0f)
			sf = 1.0f;

		lineA = sf;
	}

	if (order < 2)
	{
		int j = 0;
		for (z = -9; z < 9; z++)
		{
			for (x = -15; x < 15; x++)
			{
				glPushMatrix ();
				glTranslatef (x * 30, 0, z * 30 - 150);
				glScalef (sf, sf, sf);

				for (i = 0; i < 4; i++)
					cube->vertex[index[i]].y = CUBERAD;

				if (!stopped[j][0])
					cube->vertex[2].y = (GLfloat)(10 + cos (time+x*0.02*30) * WAVESIZE + sin(time+(z+2*CUBERAD)*0.03*30) * WAVESIZE);

				if (!stopped[j][1])
					cube->vertex[3].y = (GLfloat)(10 + cos (time+(x+2*CUBERAD)*0.02*30) * WAVESIZE + sin(time+(z+2*CUBERAD)*0.03*30) * WAVESIZE);

				if (!stopped[j][2])
					cube->vertex[6].y = (GLfloat)(10 + cos (time+x*0.02*30) * WAVESIZE + sin(time+z*0.03*30) * WAVESIZE);

				if (!stopped[j][3])
					cube->vertex[7].y = (GLfloat)(10 + cos (time+(x+2*CUBERAD)*0.02*30) * WAVESIZE + sin(time+z*0.03*30) * WAVESIZE);

				for (i = 0; i < 4; i++)
				{
					if (row > 32)
					{
						if (abs (cube->vertex[index[i]].y - CUBERAD) < 0.0001f)
							stopped[j][i] = true;
					}
				}

				cube->render ();
				glPopMatrix ();
				j++;
			}
		}
	}
	else
	{
		lineA -= delta;
		cam.pos[1] -= delta * 20.0f;
		cam.pos[2] -= delta * 60.0f;
		cam.tgt[1] -= delta * 30.0f;
		cam.tgt[2] = -150.0f;

		if (cam.pos[1] < 0.0f) cam.pos[1] = 0.0f;
		if (cam.pos[2] < -120.0f) cam.pos[2] = -120.0f;
		if (cam.tgt[1] < 0.0f) cam.tgt[1] = 0.0f;
		if (lineA < 0.0f) lineA = 0.0f;
		for (int i = 0; i < cube->nVertices; i++)
		{
			cube->vertex[i].a -= delta*0.5;
			if (cube->vertex[i].a < 0.01f)
				cube->vertex[i].a = 0.01f;
		}


		GLfloat r = 30.0f;

		if (lapsedtime > 12)
		{
			r = ((12 - lapsedtime)*0.5 + 1) * 30.0f;
			if (r < 0)
				r = 0.0;
		}
		for (z = -9; z < 9; z++)
		{
			for (x = -15; x < 15; x++)
			{
				glPushMatrix ();
				glTranslatef (x * r, 0, z * r - 150);
				sf = sqrt (x*x+(z-3)*(z-3));
				if (sf > 2.5)
					sf = (9 - lapsedtime)*0.33 + 1;
				else
					sf = 1.0f;
				glScalef (sf, sf, sf);
				
				if (sf > 0)
					cube->render ();
				glPopMatrix ();
			}
		}
	}
	Draw2DImage (TID_RAVEN, 0, 80.2, 79, 1.0);
	glText2D ("Shaven Raven", 0.30, 0.45, 0.4);

	lasttime = time;
}