	page	240, 132
;XMAS.ASM	2000-DEC-24
;A Christmas card from Boreal
;
;Assemble with:
; tasm /m xmas
; tlink /t xmas

	.386
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg
;	assume ax=0, bx=0, cx=00FFh, si=0100h, df=1

	org	100h
start:	mov	fs, ax			;fs:= 0 (used for time delay later)
	mov	al, 13h			;set graphic mode 13h (ah=0)
	int	10h			; 320x200 with 256 colors

	mov	ax, 1124h		;select 8x16 font
	inc	bx			;bl:=1 for 14 rows of characters
	int	10h

	mov	ax, 1300h		;write string
	mov	bl, 0Ch			;light red; (bh=0 = page 0)
	mov	cl, 12			;number of characters in msg (ch=0)
	mov	dx, 11*100h+14		;character cell row and column
	mov	bp, offset msg
	int	10h

	mov	bp, offset random	;set bp to call "random" subroutine

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Make a forest of triangular trees. The lower left corner of a tree is X0,Y0.

	mov	cl, 15			;number of trees (ch=0)
xmas10:	push	ds			;es:= ds (restore es from below)
	pop	es

	mov	ax, 30			;size:= Ran(30); = 1/2 width, 1/3 height
	pusha				;save ah=0, bh=0, cx, si=100h
	call	bp			;random
	xchg	dx, ax			;dx:= size

	mov	ax, 320			;X0:= Ran(ScrWidth)
	call	bp			;random
	xchg	bx, ax			;bx:= X0; (bh=0 thus ah:=0)

	mov	al, 40			;Y0:= Ran(40)+120-40
	call	bp			;random
	add	al, 120-40		;ax:= Y0; (ah=0)

;Create table of 3 coordinate pairs, for a total of 12 bytes
;	      X1,Y1
;               +
;
;	X0,Y0 +   + X2,Y2
;
	mov	di, si			;point to data area (0100h)
xmas15:	xchg	ax, bx			;get X coordinate
	stosw				;store in table; es:[di++] <- ax
	add	ax, dx			;X:= X + size
	xchg	ax, bx			;get Y0 coordinate
	stosw				;store in table; es:[di++] <- ax
	inc	si			;loop a total of 3 times
	jnp	xmas15			;(only low 8 bits set parity: 0, 1, 2) 

	imul	ax, dx, 3		;fix up Y1 coordinate; Y1:= size * 3
	sub	[di-6], ax

;Make a tree using the Chaos Game
; bx = X2
; dx = size, used for initial point in tree (close enough to Y0)
	push	0A000h + (40*320/16)	;point to 40th scan line in video ram
	pop	es

	imul	ax, dx, 32		;for Iter:= 1, Ran(Size*32) do...
	call	bp			;random
	xchg	cx, ax			;set loop counter; (ah:=0)

;Randomly select a corner point in table (selecting in sequence doesn't work)
xmas20:	mov	al, 3*4			;Pnt:= Ran(3*4); (ah=0)
	call	bp			;random
	and	al, 0FCh		;mask to handle 4 bytes per coordinate
	mov	ah, 1			;set up pointer to table
	xchg	si, ax

;Move halfway toward selected corner point (average the distance)
	lodsw				;get X coordinate; ax <- ds:[si++]
	add	bx, ax			;XPos:= (XPos + Points(Pnt, 0)) /2
	shr	bx, 1
	lodsw				;ax <- ds:[si++]; (ah=0)
	add	dx, ax			;YPos:= (YPos + Points(Pnt, 1)) /2
	shr	dx, 1

	imul	di, dx, 320		;PlotPoint(XPos, YPos, 78h)
	mov	byte ptr es:[bx+di], 78h ;a nice shade of (even parity) green
	loop	xmas20			;loop for all pixels in the tree

	popa				;restore ah=0, bh=0, cx, si=100h
	loop	xmas10			;loop for all the trees in the forest

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Initialize music
	mov	si, offset music	;point to the score
	cwd				;ah=0 thus dx:= 0

	in	al, 61h			;get speaker control port
	push	ax			;save initial state for exit
	or	al, 03h			;enable speaker and timer
	out	61h, al			;(shut beep noise off soon)

	mov	al, 0B6h		;set 8254 control register for counter 2
	out	43h, al			; mode 3, write low byte then high byte

;Animation loop (let it snow...let it snow...let it snow...)
; cx = 0
; dx = 0
xmas50:	not	cx			;skip snow every other 18.2Hz clock tick
	jcxz	xmas79			; (it's not a blizzard)

;I:= 320*160-1; from near the bottom up to the top...
	mov	di, 320*(160-40)-1-1	;last pixel on last line (-1 for random)
xmas70:	mov	bx, 320-1		;put handy value in bx
	cmp	di, bx			;is di pointing to top (40th) line?
	ja	xmas73			;jump if not
	mov	al, 20			;(ah=0)
	call	bp			;randomly generate a snow flake
	cmp	al, 7			;is it a snow flake? (1 chance in 20)
	jne	xmas73			;jump if not
	stosb				;else draw it; es:[di++] <- al
	dec	di			;undo ++ (and still save a byte)
xmas73:
	cmp	byte ptr es:[di], ah	;is there is a snow flake (7) here?
	jp	xmas76			;jump if not (7 has odd parity)
	mov	al, 3			;randomly pick 1 of 3 places to fall
	call	bp			;J:= Ran(3) -1 +320 +I; (ah=0)
	add	bx, ax
	cmp	byte ptr es:[bx+di], ah	;is flake falling into an empty spot?
	jne	xmas76			;jump if not
	xchg	byte ptr es:[di], ah	;erase flake at old position
	xchg	byte ptr es:[bx+di], ah	;draw flake at new position
xmas76:	dec	di			;loop for all pixels in scene
	jne	xmas70
xmas79:

; ah = 0
; si = music (score) pointer
; cx = low / high nibble selector
; dx = note duration timer (ticks)

	dec	dx			;check note duration timer
	jg	snd60			;jump if still sustaining note
	mov	al, 1			;pause between notes, for attack
	je	snd55			;jump if between notes
					;else get next note
	dec	si			;backup and re-fetch previous note
	lodsb				;al <- ds:[si++]
	shr	al, 4			;get note from high nibble
	je	snd60			;jump if terminator--leave sound off

	jcxz	snd51			;jump if cx=0 and use high nibble
	 lodsb				;else get note from low nibble
snd51:	mov	bx, ax			;save note (bh=0)

	and	al, 1			;set up note duration timer
	inc	ax			; bit 0: 0  1
	imul	dx, ax, 2		; dx:    2  4

	and	bl, 0Eh			;get note frequency
	mov	ax, [bx+pertbl]		;look up period (for frequency) in table
snd55:	out	42h, al			;set 8254 timer
	mov	al, ah
	out	42h, al
snd60:
;Wait for next system timer interrupt (pure DOS can get awaw with a single hlt)
	mov	al, fs:[46Ch]		;read system timer byte
wait1:	cmp	al, fs:[46Ch]		;wait for it to change
	je	wait1

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Exit program if a key has been struck
	mov	ah, 01h			;get keyboard status
	int	16h
	mov	ax, 0003h		;set to restore text mode; (ah:=0)
	je	xmas50			;loop if no keystroke
	int	10h			;restore display to standard text mode

	pop	ax			;restore (disable) speaker and timer
	out	61h, al
;	ret				;return to DOS via int 20h in PSP

;-------------------------------------------------------------------------------
;Return a random number between 0 and the value in ax-1
; (ax <= 32767)
;
random:	push	cx			;save registers
	push	dx

	cwd				;dx:= 0
	xchg	cx, ax			;set up divisor

	imul	ax, [bp+delta], 121	;seed:= (seed*121 + 1) modulo 65536
	inc	ax			;"Master Class Assembly Language" p 838
	mov	[bp+delta], ax

	idiv	cx			;ax:= dx:ax/cx  dx:= remainder
	xchg	ax, dx			;return remainder in ax

	pop	dx			;restore registers
	pop	cx
	ret


msg	db	"MERRY XMAS !"		;message
seed	equ	word ptr msg+2		;initial random number seed is in msg
delta	equ	seed-random		;(saves a byte by using bp offset, also
					; tricks tasm into doing what we need)
;Music Table: 2 notes per byte, low nibble first. The low bit of a nibble deter-
; mines the duration (quarter/eighth note); the high 3 bits select the note.
music	db	10010011b 		;D2 G2
	db	10101000b, 01101000b	;G1 A1  G1 F1
	db	01010101b, 10110101b	;E2 E2  E2 A2
	db	11001010b, 10001010b	;A1 B1  A1 G1
	db	00110111b, 11010011b	;F2 D2  D2 B2
	db	11101100b, 10101100b	;B1 C1  B1 A1
	db	01011001b, 00100010b	;G2 E2  D1 D1
	db	10110101b, 10010111b	;E2 A2  F2 G4 (last note should be G8)
;	db	00h			;terminator

;Period Table			      Index   Note   Freq
pertbl	dw	   1			;0  rest note = very high freq
	dw	4063			;1    4D    293.66
	dw	3620			;2    4E    329.63
	dw	3225			;3    4F#   369.99
	dw	3044			;4    4G    392.00
	dw	2712			;5    4A    440.00
	dw	2416			;6    4B    493.88
	dw	2280			;7    5C    523.25

cseg	ends
	end	start
