// mutagenDlg.h : header file
//

#if !defined(AFX_MUTAGENDLG_H__06C5B167_D5D4_11D5_BCBD_00C02669565E__INCLUDED_)
#define AFX_MUTAGENDLG_H__06C5B167_D5D4_11D5_BCBD_00C02669565E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "generate.h"
#include "fio_staff.h"
#include <Mmsystem.h>

/////////////////////////////////////////////////////////////////////////////
// CMutagenDlg dialog

class CMutagenDlg : public CDialog
{
// Construction
public:
	int GenerateSamples();
	void WriteWaveHead16m(FILE  *f,int srate,int slen);
	void NewPack();
	void SetSamplesNum(int num);
	int LoadTXT(char *fname);
	int LoadCSM(char *fname);
	int SaveTXT(char *fname);
	int SaveCSM(char *fname);
	void ShowSample(int smp_num);
  void UpdateSample(int smp_num);
	CMutagenDlg(CWnd* pParent = NULL);	// standard constructor
  char tmp_path[256];

// Dialog Data
	//{{AFX_DATA(CMutagenDlg)
	enum { IDD = IDD_MUTAGEN_DIALOG };
	CButton	m_chk_render;
	CButton	m_chk_cr;
	CEdit	m_edt_smpn;
	CSpinButtonCtrl	m_spin1;
	CComboBox	m_cmb_gen;
	CComboBox	m_cmb_srate;
	CComboBox	m_cmb_smp;
	CString	m_smpn;
	CString	m_freq;
	CString	m_att;
	CString	m_sust;
	CString	m_rel;
	CString	m_smp_len;
	CString	m_pitch_env;
	CString	m_cutoff;
	CString	m_resonance;
	CString	m_cut_env;
	CString	m_res_env;
	CString	m_pass_high;
	CString	m_pass_low;
	CString	m_pass_high_env;
	CString	m_pass_low_env;
	CString	m_amplitude;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMutagenDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation

  //!!!!!!!!!!!!!!!!!! --------- :)
#pragma optimize("",off)
  int samples;
  int cur_smp;
  SampleInfo si[256];
  char wfile[512];
  int  ftype;
#pragma optimize("",on)
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CMutagenDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnHelpAbout();
	afx_msg void OnDeltaposSpin1(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchangeCmbSmp();
	afx_msg void OnFilestaffOpen();
	afx_msg void OnBtnPass();
	afx_msg void OnSelchangeCmbSrate();
	afx_msg void OnChangeEdtFreq();
	afx_msg void OnChangeEdtAtt();
	afx_msg void OnChangeEdtSust();
	afx_msg void OnChangeEdtRel();
	afx_msg void OnChangeEdtPitchEnv();
	afx_msg void OnSelchangeCmbGen();
	afx_msg void OnCheckCr();
	afx_msg void OnChangeEdtFreqCut();
	afx_msg void OnChangeEdtFreqRes();
	afx_msg void OnChangeEdtCutEnv();
	afx_msg void OnChangeEdtResEnv();
	afx_msg void OnChangeEdtFreqLowf();
	afx_msg void OnChangeEdtFreqHighf();
	afx_msg void OnChangeEdtLowfEnv();
	afx_msg void OnChangeEdtHighfEnv();
	afx_msg void OnFilestaffNew();
	afx_msg void OnFilestaffSaveas();
	afx_msg void OnFilestaffExit();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnClose();
	afx_msg void OnFilestaffGenerate();
	afx_msg void OnBtnPlay();
	afx_msg void OnBtRender();
	afx_msg void OnChangeEdtAmplitude();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MUTAGENDLG_H__06C5B167_D5D4_11D5_BCBD_00C02669565E__INCLUDED_)
