.model tiny                                 ;written by Uwe Hermann
.code                                       ;a.k.a. pAin/Chaos Bites
.286                                        ;uh1763@bingo.baynet.de

              org 100h
Step1:
              int 16h                       ;wait for key = NBB = 1..9

              sub al, 49
              cmp al, 5
              jnc Step6

              mov bl, al                    ;tmp. save al in bl
Step2:
              xor ah, ah                    ;wait for key = CLR = 1..9
              int 16h

              sub al, 48
              or al, al                     ;al=0 --> Step6
              jz Step6
                                            ;now al=color
Step3:
              push ax
              mov ax, 13h                   ;enter mode 13h
              int 10h
              pop ax

Step4:
              push 0a000h                   ;init es
              pop es

              shl bl, 1                     ;bx=bx*2
              mov di, [MyTable+bx]          ;cs=ds=es, so i needn't use a
                                            ;segment override

              cmp bl, 4*2                   ;Middle Shape?
              jl NotMiddle
              je Middle

BlackMiddle:
              xor al, al                    ;color=0
              mov di, 50*320+80             ;Middle
Middle:
              mov bl, 19                    ;to mark that we were here before

NotMiddle:
              mov si, 100
MyLoop:
              mov cx, 160
              rep stosb

              add di, 160

              dec si                        ;in this case LOOP isn't smaller
              jnz MyLoop                    ;because i need CX for the REP

              cmp bl, 4*2                   ;Middle Shape?
              jl BlackMiddle                ;yes -> End; no -> draw black box

Step5:
              xor ah, ah                    ;wait for keypress
              int 16h

Step6:
              mov ax, 3h
              int 10h

Step7:
              ret                           ;shorter than INT 20h

MyTable dw 0
        dw 160
        dw 100*320
        dw 100*320+160
        dw 50*320+80

end Step1