//Circle Drawing

void vmode(short mode)
{
_asm {	mov ax,mode
	int 10h
}
}

void anykey()
{
_asm {	xor ax,ax
	int 16h
}
}

void putpixel(int x,int y,char color)
{
_asm {	mov edi,0xa0000
	mov eax,y
	shl eax,6
	add edi,eax
	shl eax,2
	add edi,eax
	add edi,x
	mov al,color
	mov [edi],al
}
}

void circle(int x,int y,int r,char color)
{

 int max,min;
 int rmax,rmin;
 max=0;
 min=r;
 rmax=r*r;
 rmin=r*(r-1);

 while(max<=min) 
 {
  putpixel(x+max,y-min,color);
  putpixel(x-max,y-min,color);
  putpixel(x+max,y+min,color);
  putpixel(x-max,y+min,color);
  putpixel(x-min,y-max,color);
  putpixel(x+min,y-max,color);
  putpixel(x-min,y+max,color);
  putpixel(x+min,y+max,color);
  max++;
  if((rmax-=max*2)<=rmin) min--,rmin-=min*2; 
 }
}

void main()
{
	vmode(0x13);
	circle(160,100,80,15);
	anykey();
	vmode(3);
}