.model small          ; small model plenty big for this demo
.stack 256            ; allocate 256 bytes for the stack
.286                  ; must use cuz insb and outsb is 286 or higher code
.data                 ; start of the data segment
include redhot.inc    ; external file containing picture data and palette
.code                 ; start of code segment
include greypal.inc   ; external file containing the greyscale palette
include ansi.inc      ; external file containing the ansi data
fadepalette  db      768     dup (0)   ; make 768 zeros for fading purposes
sorry  DB 'BUY A VGA YOU CHEAP LAMER!!!',10,13,'$' ;message for non VGA lamers
start:  mov     ax,cs        ; move cs to ax
        mov     ds,ax        ; move cs to ds
        mov     es,ax        ; move cs to es
        mov     ax,1a00h     ; set up to check video card
        int     10h          ; do it
        cmp     bl,7         ; was a mono VGA detected?
        je      vgaok        ; if so go run the program
        cmp     bl,8         ; was a color VGA detected?
        je      vgaok        ; if so go run the program
        mov     dx,offset sorry   ; if not, set up for message
        mov     ah,9         ; set up to print string
        int     21h          ; do it
        mov     ah,4ch       ; set up for exit
        int     21h          ; back to dos you lamer
vgaok:  mov     ax,0013h     ; set up for 320X200X256
        int     10h          ; do it
        mov     dx,offset fadepalette ; move dx to the offset of the palette
        mov     ax,1012h     ; setup for setting the palette
        mov     bx,0         ; start at the first color
        mov     cx,256       ; do all 256 colors, the easy way
        int     10h          ; pallete setup complete, all zeros (black)

        mov     ax,@data     ; move ax to data segment
        mov     ds,ax        ; move data segment to ds
        mov     ax,0a000h    ; point ax to start of video memory for this mode
        mov     es,ax        ; point ex to start of video memory
        mov     di,0         ; be sure di is at the start
        mov     si,offset image ; move si to the offset of the image
        mov     cx,32000
        rep     movsw        ; moves 64000 bytes of picture to the screen
stayin: call    fadeup       ; calls fadeup procedure
        call    delay        ; keep it grey for about 3 seconds using delay proc
        call    fadeupred    ; calls fadeupred procedure
        call    delay        ; keep it red for about 3 seconds
        mov     ah,1         ; check keystroke buffer
        int     16h          ; was a key hit?
        jz      stayin       ; if not, loop back to label stayin
        call    fade         ; if key pressed call fade procedure to go to black
        call    putansi      ; calls putansi, sets 50 line mode and display ansi
        mov     ah,0         ; clear keyboard buffer
        int     16h          ; done
        mov     ax,1         ; has another been hit? if not you see the ansi
        int     16h          ; until you hit another key
        call    fade         ; calls fade procedure to fade out ansi
        mov     ax,0003      ; set up for normal text mode
        int     10h          ; do it
        mov     ax,4c00h     ; setup for exit
        int     21h          ; back to good 'ol dos, windows sux

fade    PROC                 ; start of fade procedure
        mov     ax,cs        ; moves code segment to ax
        mov     ds,ax        ; now code segment to ds
        mov     es,ax        ; now code segment to es
        mov     dx,03c7h     ; Read pallette entries
        xor     al,al        ; set for read/write
        out     dx,al        ; output the control
        add     dx,2         ; setup dx to point to 03c9h
        mov     di, offset fadepalette ; Sets up ES:DI to point to fadepalette
        mov     cx,3         ; set up to do loop three times
fade1:  push    cx
        mov     cx,256       ; get ready for 768 bytes from port 03c9h, 256 at a time
        push    dx           ; let's check for retrace so no snow occurs
        mov     dx,03dah     ; this is standard retrace checker
fade2:  in      al,dx        ; wait until writing to the screen
        test    al,08h
        jz      fade2
fade3:  in      al,dx        ; wait until not writing to the screen
        test    al,08h
        jnz     fade3
        pop     dx           ; maximizes time for not drawing to the screen
        rep     insb         ; read in 768 palette bytes to fadepalette
        pop     cx           ; in 256 byte chunks---NO SNOW
        loop    fade1
        mov     cx,63        ; let's decrement 63 times so all go to zero
fade4:  push    cx           ; save it for later
        xor     bx,bx        ; reset bx
        mov     cx,768       ; for all 768 bytes
fade5:  cmp     Byte Ptr fadepalette[bx],0 ; compare the color to zero
        je      fade6                      ; if equal to zero don't decrement
        dec     Byte Ptr fadepalette[bx]   ; if not, decrement it
fade6:  inc     bx           ; point to next byte address
        loop    fade5        ; Repeat decrement 256 pal entries by 3 bytes
        mov     dx,03c8h     ; go to PEL address register
        xor     al,al        ; reset al to 0
        out     dx,al        ; output byte
        inc     dx           ; increment up to PEL data register
        mov     si, offset fadepalette ; set DS:SI to fadepalette
        mov     cx,3         ; set up to loop three times
fade7:  push    cx           ; save it
        mov     cx,256       ; move 256 bytes of palette
        push    dx           ; check for retrace again, no snow!!
        mov     dx,03dah     ; point to status indicator
fade8:  in      al,dx        ; input byte
        test    al,08h       ; test Vsync bit
        jz      fade8        ; loop until not writing to screen
fade9:  in      al,dx        ; point to status indicator
        test    al,08h       ; input byte
        jnz     fade9        ; test Vsync bit
        pop     dx
        rep     outsb        ; output to port 256 bytes of data
        pop     cx
        loop    fade7        ; 3 X 256 = 768
        pop     cx           ; reload loop variable
        loop    fade4        ; check for zero, if so, continue
        ret                  ; return to calling procedure
fade    ENDP

fadeup  PROC
        mov     ax,cs        ; move cs to ax
        mov     es,ax        ; move cs to es
        mov     di,offset greypal  ; load ES:DI to grey palette address
        mov     ax,cs        ; move cs to ax
        mov     ds,ax        ; move cs to ds
        mov     cx,63        ; set loop for 63 times
fup1:   push    cx           ; save for later
        xor     bx,bx        ; reset bx to 0
        mov     cx,768       ; set up for entire palette 768 bytes
fup2:   mov     al,es:[di+bx] ; move to first value
        cmp     al,Byte Ptr fadepalette[bx] ; compare greypal to fadepalette
        je      fup3         ; if equal don't increment
        inc     Byte Ptr fadepalette[bx]  ;increment if not equal
fup3:   inc     bx           ; bump it up to next value
        loop    fup2         ; do it for all 768 bytes
        mov     dx,03c8h     ; go to PEL address register
        xor     al,al        ; setup write to zero
        out     dx,al        ; output byte
        inc     dx           ; move up to PEL data register
        mov     si, offset fadepalette  ; set DS:SI point to fadepalette
        mov     cx,3         ; set up for three loops
fup4:   push    cx           ; save for later
        mov     cx,256       ; get ready to move 256 bytes
        push    dx           ; save dx
        mov     dx,03dah     ; point to status indicator for retrace check
fup5:   in      al,dx        ; input byte
        test    al,08h       ; test Vsync bit
        jz      fup5
fup6:   in      al,dx        ; Point to status indicator
        test    al,08h       ; input byte
        jnz     fup6         ; test Vsync bit
        pop     dx           ; restore dx
        rep     outsb        ; output to port 256 bytes of data
        pop     cx
        loop    fup4         ; do the loop 3 times
        pop     cx           ; reload loop variable
        mov     ah,1         ; check for a keystroke
        int     16h
        jnz     fup7         ; if key hit jump out of loop
        loop    fup1         ; do loop 63 times for 63 levels of intensity
fup7:   ret                  ; go back to calling procedure
fadeup  ENDP

fadeupred PROC
        mov     ax,@data    ; move ax to data seg
        mov     es,ax       ; move es to data seg
        mov     di,offset palette ; load ES:DI to palette address
        mov     ax,cs       ; move cs to ax
        mov     ds,ax       ; move cs to ds
        mov     cx,63       ; do it for 63 times or intensity levels
fupr1:  push    cx          ; save it for later
        xor     bx,bx       ; reset bx to 0
        mov     cx,768      ; do all 768 bytes
fupr2:  mov     al,es:[di+bx]  ; move to first value
        cmp     al,Byte Ptr fadepalette[bx] ; compare palette to fadepalette
        je      fupr3       ; if equal don't decrement
        dec     Byte Ptr fadepalette[bx]  ; dec value if not equal
fupr3:  inc     bx          ; bump up to next byte
        loop    fupr2       ; do all 768 bytes
        mov     dx,03c8h    ; go to PEL address register
        xor     al,al       ; set al to zero
        out     dx,al       ; output byte so we are at first byte
        inc     dx          ; go up to PEL data register
        mov     si, offset fadepalette ; set DS:SI to fadepalette
        mov     cx,3        ; loop three times
fupr4:  push    cx          ; save for later
        mov     cx,256      ; move 256 bytes (one third of palette)
        push    dx          ; save dx
        mov     dx,03dah    ; check for retrace
fupr5:  in      al,dx       ; input byte
        test    al,08h      ; test Vsync bit
        jz      fupr5
fupr6:  in      al,dx       ; point to status indicator
        test    al,08h      ; input byte, test Vsync bit
        jnz     fupr6       ; wait until not writing to screen
        pop     dx          ; restore dx to PEL data register
        rep     outsb       ; output to port 256 bytes of data
        pop     cx
        loop    fupr4       ; go do it three times for entire palette
        pop     cx          ; reload loop variable
        mov     ah,1        ; check for a keystroke
        int     16h         ; was a key pressed?
        jnz     fupr7       ; if so, exit this procedure
        loop    fupr1       ; do it 63 times for all intensity levels
fupr7:  ret                 ; return to calling procedure
fadeupred    ENDP


putansi PROC
        mov     ax,1202h    ; select 400 scan lines
        mov     bl,30h
        int     10h         ; done
        mov     ax,0003h    ; go to normal text mode
        int     10h         ; done
        mov     ax,1112h    ; load the 8X8 character set
        mov     bl,0        ; block number
        int     10h         ; done
        mov     dx,03d4h    ; go to the crt controller register
        mov     al,0ah      ; cursor start register
        out     dx,al       ; input the byte
        inc     dx          ; go up to 03d5 to write
        mov     al,32       ; cursor on/off bit
        out     dx,al       ; it's off now
        mov     cx,47       ; loop 47 times to move up entire screen (almost)
        mov     dx,7360     ; move dx to bottom of the screen
ansi1:  push    ax          ; retrace check for smoothness and
        push    dx          ; to slow it down
        mov     dx,03dah    ; input status #1 register
ansi2:  in      al,dx
        test    al,08       ; test VR (bit 3)
        jz      ansi2
ansi3:  in      al,dx
        test    al,08
        jnz     ansi3
        pop     dx
        pop     ax
        mov     ax,cs       ; move cs to ax
        mov     ds,ax       ; move cs to ds
        mov     ax,0b800h   ; move ax to video screen top left
        mov     es,ax       ; move es to screen
        mov     di,dx       ; point di to bottom of screen
        mov     si,offset IMAGEDATA  ; point si to ansi data
        push    cx          ; save cx
        mov     cx,4000     ; number of bytes to move/2
        cld                 ; set direction flag
        rep     movsw       ; move the data from si to di
        pop     cx          ; restore cx value
        sub     dx,160      ; move dx up one line
        loop    ansi1       ; loop till ansi goes up entire screen
        ret                 ; return to calling program
putansi ENDP

delay   PROC                ; start of delay procedure, for about three secs
        mov     cx,100      ; used for counter
        mov     dx,03dah    ; use video retrace, pretty standard from
delay1: in      al,dx       ; one machine to another
        test    al,08       ; test VR (bit 3)
        jz      delay1
delay2: in      al,dx
        test    al,08
        jnz     delay2
        mov     ah,1        ; check for a keystroke
        int     16h         ; was a key pressed?
        jnz     delay3      ; if so, exit this procedure
        loop    delay1      ; do it 100 times
delay3: ret                 ; return to calling procedure
delay   ENDP
        END start
