Unit LList;

Interface

Type
    NodePtrT = ^NodeT;
    DataType = Array [0..11] Of Char;
    NodeT    = Record
          Data : DataType;
	  Prev : NodePtrT;
	  Next : NodePtrT;
    End;

Function MakeNode(Data : DataType) : NodePtrT;
Procedure InsertAtHead(Var L : NodePtrT; NodePtr : NodePtrT);
Procedure InsertAtTail(Var L : NodePtrT; NodePtr : NodePtrT);
Procedure InsertByData(Var L : NodePtrT; NodePtr : NodePtrT);
Function Search(L : NodePtrT; Element : Char) : Boolean;
Function RemoveNode(Var L : NodePtrT) : NodePtrT;

Implementation

Uses Crt, Strings;

Function MakeNode(Data : DataType) : NodePtrT;
Var NewP : NodePtrT;
Begin
     New(NewP);
     NewP^.Data := Data;
     NewP^.Prev := NIL;
     NewP^.Next := NIL;
     MakeNode   := NewP;
End;

Procedure InsertAtHead(Var L : NodePtrT; NodePtr : NodePtrT);
Begin
     NodePtr^.Next := L;
     If (L <> Nil) And (L^.Prev <> Nil) Then Begin
       NodePtr^.Prev := L^.Prev;
     End;
     L^.Prev := NodePtr;
     L := NodePtr;

End;

Procedure InsertAtTail(Var L : NodePtrT; NodePtr : NodePtrT);
Begin
     If L = NIL Then Begin
        InsertAtHead(L, NodePtr);
     End
     Else Begin
        If L^.Next <> NIL Then Begin
           InsertAtTail(L^.Next, NodePtr);
        End
	Else Begin
           L^.Next := NodePtr;
           NodePtr^.Prev := L;
        End;
     End;
End;

Procedure InsertByData(Var L : NodePtrT; NodePtr : NodePtrT);
Var Done : Boolean;
Begin
     Done := False;
     If (L <> NIL) Then Begin
        If (L^.Next = NIL) And (Done <> TRUE) Then Begin
	   If StrComp(L^.Data, NodePtr^.Data) > 0 Then Begin InsertAtHead(L, NodePtr); Done := TRUE; End;
	   If StrComp(L^.Data, NodePtr^.Data) < 0 Then Begin InsertAtTail(L, NodePtr); Done := TRUE; End;
	End;
        If (L^.Next <> NIL) And (Done <> TRUE) Then Begin
	   If StrComp(L^.Data, NodePtr^.Data) > 0 Then Begin
              InsertAtHead(L, NodePtr); Done := TRUE;
           End
	   Else Begin
              InsertByData(L^.Next, NodePtr);
           End;
	End;
     End
     Else Begin
        InsertAtHead(L, NodePtr);
     End;
End;

Function Search(L : NodePtrT; Element : Char) : Boolean;
Begin
     If L <> NIL Then Begin
        If Ord(L^.Data[0]) = Ord(Element) Then Begin
           Search := TRUE;
        End
	Else Begin
           Search := Search(L^.Next, Element);
        End;
     End
     Else Begin
        Search := FALSE;
     End;
End;

Function RemoveNode(Var L : NodePtrT) : NodePtrT;
Var P : NodePtrT;
Begin
     If L <> Nil Then Begin
        P := L;
        If L^.Prev <> Nil Then Begin
           L^.Prev^.Next := L^.Next;
        End;
        If L^.Next <> Nil Then Begin
           L^.Next^.Prev := L^.Prev;
        End;
        Dispose(P);
        RemoveNode := P;
     End
     Else Begin
          RemoveNode := Nil;
     End;
End;

Begin
End.