Unit SauceUnt; { Unit to read, write, erase and check if a file has a       }
               { valid sauce record.                                        }
Interface

Const UnitVer    = '1.1TNA';                   { Version of SAUCE Unit      }
      CommentsIO = True;                       { Read/Write SAUCE Comments? }
      BackErase  = False;                      { Backup file when erasing   }
                                               { SAUCE information          }

Type SAUCERec = Record                         {     Sauce record info      }
              ID       : Array[1..5]  of Char; {      from  sauce.txt       }
              Version  : Array[1..2]  of Char; {             |              }
              Title    : Array[1..35] of Char; {             |              }
              Author   : Array[1..20] of Char; {             |              }
              Group    : Array[1..20] of Char; {             |              }
              Date     : Array[1..8]  of Char; {             |              }
              FileSize : Longint;              {             |              }
              DataType : Byte;                 {             |              }
              FileType : Byte;                 {             |              }
              TInfo1   : Word;                 {             |              }
              TInfo2   : Word;                 {             |              }
              TInfo3   : Word;                 {             |              }
              TInfo4   : Word;                 {             |              }
              Comments : Byte;                 {             |              }
              Flags    : Byte;                 {             |              }
              Filler   : Array[1..22] of Char; {             |              }
End;                                           {            \|/             }

Type CommentRec = Array [1..100] Of Array [1..64] Of Char;

Var SAUCE       : SauceRec;
    Comments    : CommentRec;

{*--[ Get the SAUCERec from the file: ]------------------------------------*}
Procedure GetSAUCE (Filename  : String);
{*--[ END ]----------------------------------------------------------------*}

{*--[ See if file contains a valid SAUCERec: ]-----------------------------*}
Function  ValidSAUCE (Filename  : String):Boolean;
{*--[ END ]----------------------------------------------------------------*}

{*--[ Erase SAUCE from the file: ]-----------------------------------------*}
Procedure EraseSAUCE(Filename : String);
{*--[ END ][Special thanks to Nivenh for help on this one ]----------------*}

{*--[ Write the SAUCERec to the file: ]------------------------------------*}
Procedure WriteSAUCE (Filename  : String);
{*--[ END ]----------------------------------------------------------------*}

Implementation

{*--[ Get the SAUCERec from the file: ]------------------------------------*}

Procedure GetSAUCE (Filename  : String);

Var TempFile    : File;
    CommentID   : Array [1..5] Of Char;
    TempCounter : Integer;

Begin
  Assign(TempFile, Filename);
  {$I-}
  Reset(TempFile, 1);
  {$I+}
  If IOResult = 0 Then Begin
    If (FileSize(TempFile) > 128) Then Begin
      Seek(TempFile,(FileSize(TempFile) - SizeOf(SAUCE)));
      Blockread(TempFile, SAUCE, SizeOf(SAUCE));
      If (CommentsIO And (SAUCE.Comments > 0)) Then Begin
        Seek(TempFile, FileSize(TempFile)-128-(SAUCE.Comments*64)-5);
        Blockread(TempFile, CommentID, SizeOf(CommentID));
        If (CommentID = 'COMNT') Then Begin
          For TempCounter := 1 To Sauce.Comments Do Begin
            Blockread(TempFile, Comments[TempCounter], 64);
          End;
        End;
      End;
    End;
    Close(TempFile);
  End;
End;

{*--[ END ]----------------------------------------------------------------*}

{*--[ See if file contains a valid SAUCERec: ]-----------------------------*}

Function  ValidSAUCE (Filename  : String):Boolean;

Var TempFile : File;
    SAUCE    : SAUCERec;

Begin
  Assign(TempFile, Filename);
  {$I-}
  Reset(TempFile, 1);
  {$I+}
  If IOResult = 0 Then Begin
    If (FileSize(TempFile) > 128) Then Begin
      Seek(TempFile,(FileSize(TempFile) - SizeOf(SAUCE)));
      Blockread(TempFile, SAUCE, SizeOf(SAUCE));
    End;
    Close(TempFile);
    If SAUCE.ID = ('SAUCE') Then Begin
      ValidSAUCE := True;
    End
    Else Begin
      ValidSAUCE := False;
    End;
  End
  Else Begin
    ValidSAUCE := False;
  End;
End;

{*--[ END ]----------------------------------------------------------------*}

{*--[ Erase SAUCE from the file: ]-----------------------------------------*}

Procedure EraseSAUCE(Filename : String);

Var OldFile  : File Of Byte;
    NewFile  : File Of Byte;
    FileLen  : Longint;
    Counter1 : Longint;
    Counter2 : Byte;
    Backup   : String;

Begin
  Assign(OldFile, Filename);
  {$I-}
  Reset(OldFile);
  {$I+}
  If IOResult = 0 Then Begin
    Assign(NewFile, Copy(Filename, 1, Length(Filename) - 3) + 'NEW');
    Rewrite(NewFile);
    If (SAUCE.Comments > 0) Then Begin
      FileLen := FileSize(OldFile) - 128 - SAUCE.Comments * 64 - 5;
    End
    Else Begin
      FileLen := FileSize(OldFile) - 128;
    End;
    For Counter1 := 1 To FileLen Do Begin
      Read(OldFile, Counter2);
      Write(NewFile, Counter2);
    End;
    Close(OldFile);
    If (BackErase) Then Begin
      Backup := Copy(Filename, 1, Length(Filename) - 3) + 'BAK';
      Rename(OldFile, Backup);
    End
    Else Begin
      Erase(OldFile);
    End;
    Close(NewFile);
    Rename(NewFile, Filename);
  End;
End;

{*--[ END ][Special thanks to Nivenh for help on this one ]----------------*}

{*--[ Write the SAUCERec to the file: ]------------------------------------*}

Procedure WriteSAUCE (Filename  : String);

Var TempFile    : File;
    CommentM    : Array [1..5] Of Char;
    EofM        : Char;
    EofCheck    : Char;
    TempCounter : Integer;

Begin
  EofM := #26;
  CommentM := 'COMNT';
  Assign(TempFile, Filename);
  {$I-}
  Reset(TempFile,1);
  {$I+}
  If IOResult = 0 Then Begin
    IF ValidSAUCE(Filename) = True Then Begin
       Close(TempFile);
       EraseSauce(Filename);
       Assign(TempFile, Filename);
       Reset(TempFile,1);
       Seek(TempFile,FileSize(TempFile)-1);
    End
    Else Begin
      Seek(TempFile,FileSize(TempFile)-1);
    End;
    Blockread(TempFile, EofCheck, SizeOf(EofCheck));
    If (EofCheck <> EofM) Then Begin
      BlockWrite(TempFile, EofM, SizeOf(EofM));
    End;
    Seek(TempFile, FileSize(TempFile));
    If (CommentsIO And (SAUCE.Comments > 0)) Then Begin
      BlockWrite(TempFile, CommentM, SizeOf(CommentM));
      For TempCounter := 1 to SAUCE.Comments Do Begin
        BlockWrite(TempFile, Comments[TempCounter], 64);
      End;
    End;
    Blockwrite(TempFile, SAUCE, Sizeof(Sauce));
    Close(TempFile);
  End;
End;

{*--[ END ]----------------------------------------------------------------*}

Begin
End.