program D_Menu_v1_1a;

uses crt, dos, utils, ddplus;

type UserRecord = record
       nick : string[20];
       menu : byte;
     end;
     Configuration = record
       userfile, textdir, menu1, menu2, menu3, menu4, menu5 : string;
     end;
     Cfgfile = file of Configuration;

var UserFound : boolean;
    tmp : char;
    tmps : string;
    MenuNum : integer;
    UserRec : UserRecord;
    UserDat : file of UserRecord;
    config : Configuration;

procedure pause;
  begin
    swriteln('');
    swriteln('Press any key to continue...');
    repeat until skeypressed;
    sread_char(tmp);
  end;

procedure setbar(num, counter, x, y : byte; s : string);
  begin
    if num = counter then set_color(12, 4)
    else set_color(8, 0);
    sgoto_xy(x,y);
    s := CString('                    ', s);
    swrite(s);
  end;

procedure ReadCfg;
  var f1 : cfgfile;
  begin
    assign(f1, 'd-menu.cfg');
    reset(f1);
      read(f1, config);
    close(f1);
  end;

procedure FindUser;
  begin
    userfound := FALSE;
    assign(UserDat, config.Userfile);
    if (fileexist(config.Userfile)) then reset(UserDat)
    else begin
      rewrite(UserDat);
      UserRec.nick := User_first_name + user_last_name;
      UserRec.menu := 1;
      write(UserDat, UserRec);
      userfound := TRUE;
    end;
    if filesize(UserDat) <> 0 then
      repeat
        read(UserDat, UserRec);
        if UserRec.nick = user_first_name + user_last_name then userfound := TRUE;
      until eof(UserDat);
    close(UserDat);
    if UserFound = FALSE then begin
      reset(UserDat);
      seek(UserDat, filesize(UserDat));
      UserRec.nick := user_first_name + user_last_name;
      UserRec.menu := 1;
      write(UserDat, UserRec);
      UserFound := TRUE;
      close(UserDat);
    end;
  end;

procedure Setup;
  var yn : boolean;
      s, tmps : string;
      f1 : cfgfile;
      counter : shortint;
  begin
    if fileexist('d-menu.cfg') then begin
      yn := FALSE;
      set_color(4, 0);
      writeln('WARNING: your config file already exists...');
      write('Do you wish to over write? [Y/N] ');
      tmp := readkey;
      write(tmp);
      writeln;
      case tmp of
        #78: halt;
      end;
    end;
    clrscr;
    assign(f1, 'd-menu.cfg');
    rewrite(f1);
    set_color(7, 0);
    write('What is the filename of the userfile? (ex. D-Menu.usr) ');
      readln(config.userfile);
    write('Directory to copy the menu''s to (ex. C:\TG\TEXT): ');
      readln(config.textdir);
      if not direxist(config.textdir) then begin
        writeln;
        set_color(4, 0);
        writeln('WARNING: the directory you specified does not exist.');
        if YesNo('Ok to create? [Y/N] ') then mkdir(config.textdir)
        else begin
          set_color(4, 0);
          writeln('WARNING: the directory ', config.textdir, 'has NOT been created.');
        end;
        set_color(7, 0);
      end;
      counter := 1;
      repeat
        tmps := itos(counter);
        tmps := config.textdir + '\menu' + tmps;
        if not direxist(tmps) then begin
          set_color(4, 0);
          if yn = FALSE then begin
            writeln('WARNING: the menu directories do not exist.');
            set_color(7, 0);
            if YesNo('OK to create? [Y/N] ') then begin
              mkdir(tmps);
              writeln('Created directory: ' + tmps);
              yn := TRUE;
            end;
          end
          else begin
            mkdir(tmps);
            writeln('Created directory: ' + tmps);
          end;
        end;
        inc(counter);
      until counter > 5;
    write('Description of menu set #1 (20 char''s max): ');
      readln(config.menu1);
    write('Description of menu set #2 (20 char''s max): ');
      readln(config.menu2);
    write('Description of menu set #3 (20 char''s max): ');
      readln(config.menu3);
    write('Description of menu set #4 (20 char''s max): ');
      readln(config.menu4);
    write('Description of menu set #5 (20 char''s max): ');
      readln(config.menu5);
    write(f1, config);
    close(f1);
    writeln;
    writeln('D-Menu Configured Successfully...');
    halt;
  end;

procedure WriteCfg (num : integer);
  var tmpdat : file of UserRecord;
  begin
    assign(UserDat, config.userfile);
    assign(tmpdat, 'distxt.usr');
    reset(UserDat);
    rewrite(tmpdat);
    repeat
      read(UserDat, UserRec);
      if UserRec.nick = user_first_name + user_last_name then begin
        UserRec.menu := num;
        write(tmpdat, UserRec);
      end
      else write(tmpdat, UserRec);
    until eof(UserDat);
    close(UserDat);
    close(tmpdat);
    erase(UserDat);
    rename(tmpdat, config.userfile);
    set_color(8, 0);
    sgoto_xy(2,22);
    swriteln('D-Menu v1.1a by Stoned Militia/Demonic Productionz');
    pause;
    halt;
  end;

procedure SetMenu;
  begin
    sclrscr;
    displayfile('d-menu.ans');
    repeat
      setbar(1, UserRec.menu, 29, 12, config.menu1);
      setbar(2, UserRec.menu, 29, 13, config.menu2);
      setbar(3, UserRec.menu, 29, 14, config.menu3);
      setbar(4, UserRec.menu, 29, 15, config.menu4);
      setbar(5, UserRec.menu, 29, 16, config.menu5);
      sread_char2(tmp);
      case tmp of
        #0 : begin
          sread_char2(tmp);
          case tmp of
            #72, #75: begin
              if UserRec.menu > 1 then dec(UserRec.menu)
              else UserRec.menu := 5;
            end;
            #80, #77: begin
              if UserRec.menu < 5 then inc(UserRec.menu)
              else UserRec.menu := 1;
            end;
          end;
        end;
        #56, #52: begin
          if UserRec.menu > 1 then dec(UserRec.menu)
          else UserRec.menu := 5;
        end;
        #50, #54: begin
          if UserRec.menu < 5 then inc(UserRec.menu)
          else UserRec.menu := 1;
        end;
        #13:case UserRec.menu of
          1: WriteCFG(1);
          2: WriteCFG(2);
          3: WriteCFG(3);
          4: WriteCFG(4);
          5: WriteCFG(5);
        end;
      end;
    until (tmp = #27) or (upcase(tmp) = #81);
  end;

procedure LoadMenu;
  var s : string;
  begin
    FindUser;
    sclrscr;
    set_color(9, 0);
    s := itos(UserRec.menu);
    swriteln('Loading menu set #' + s + '...');
    exec(getenv('COMSPEC'), '/c copy ' + config.textdir + '\menu' + s + '\*.* ' + config.textdir + ' /y');
    swriteln('Menu set #' + s + ' loaded.');
    halt;
  end;

begin
  initdoordriver('d-menu.ctl');
  progname := 'D-Menu v1.1a by Stoned Militia';
  if not fileexist('d-menu.cfg') then begin
    writeln('You do not have a config file...');
    write('Would you like to create one? [Y/N] ');
    tmp := readkey;
    write(tmp);
    writeln;
    case tmp of
      #78: halt;
    end;
    setup;
  end;
  UserFound := FALSE;
  ReadCFG;
  tmps := paramstr(1);
  if tmps[1] = '/' then begin
    case tmps[2] of
      '?': begin
        writeln('Syntax:');
        writeln('D-MENU.EXE [options]');
        writeln('           /?       - this help menu');
        writeln('           /D<path> - the path where the drop file is found');
        writeln('           /N#      - where # is the node number');
        writeln('           /C       - configure D-Menu');
        writeln('           /L       - run it locally');
        writeln('           /R       - load user''s current menu set');
        writeln;
        writeln('D-Menu v1.1a by Stoned Miltia/Demonic BBS Modding');
        halt;
      end;
      'c': begin
        Setup;
        Halt;
      end;
      'r': begin
        LoadMenu;
        Halt;
      end;
    end; { Case tmps }
  end; { if tmps[1] = '/' }
  FindUser;
  SetMenu;
  set_color(8, 0);
  sgoto_xy(2,22);
  swriteln('D-Menu v1.1a by Stoned Militia/Demonic Productionz');
  pause;
  sclrscr;
end.