# ZO-FREQ  .MPS : File Requester (FRequest) v4 by zoob
# ----------------------------------------------------------------
#
# FRequest (C) 1998 By Zoob.  All Rights Reserved.
#

# Program information
Var VerLine1  String
Var VerLine2  String

# Constants
Var Pause_Str String    # Pause Prompt
Var Bar       String    # Big long bar
Var File1     String    # ZO-FREQ.BIN
Var File2     String    # ZO-FREQ.~~~

# Various string variables =)
Var Inpt      String
Var S         String
Var Count     Byte
Var Count2    Byte
Var NOS       Byte
Var Done      Boolean
Var fpos      longint
Var Entry     LongInt
Var Temp      Integer

# Configuration entries
Var Colour    Byte

# Colour schemes
Var C1        String
Var C2        String
Var C3        String

# Record Variables
Var User String
Var Desc String

# B E G I N  C O D E

Proc PauseScr
  Write(Pause_Str)
  s:=readkey
  write(strrep(chr(8),6))
  write(strrep(chr(32),6))
  write(strrep(chr(8),6))
PEnd PauseScr

Proc ShowInfo
  Cls
  WriteLn(VerLine1)
  WriteLn(VerLine2)
PEnd ShowInfo

Proc Request
  If InputYN('~CR'+C1+'d'+C2+'o'+C3+' you want to request a file? ')
    Cls
    WriteLn(C1,'e',C2,'n',C3,'ter the description of the file')
    Write(C3,': ')
    Inpt := Input(70, 70, 1, '')
    If Inpt <> ''
      If FExist(file1)
          FOpen(1, Bin, Append, file1)
        Else
          FOpen(1, Bin, Rewrite, file1)
      EndIf
      user := lower(useralias)
      desc := inpt
      fwriterec(1,user,30)
      fwriterec(1,desc,70)
      FClose(1)
    EndIf
  EndIf
PEnd Request

Proc View
  If InputYN('~CR'+C1+'d'+C2+'o'+C3+' you want to view the file request list? ')
    ShowInfo
    If Not FExist(file1)
        WriteLn('~CR',C1,'n',C2,'o',C3,' entries available')
        PauseScr
      Else
        Count := 0
        FOpen(1, Bin, Reset, file1)
        Repeat
          If Count = 0
              WriteLn(Bar)
              NOS := NOS + 1
              If NOS = 5
                  NOS := 1
                  PauseScr
              EndIf
            ElseIf Count = 1
              FReadRec(1, S, 30)
              write(C1,'u',C2,'s',C3,'er ',C2,': ',C3)
              WriteLn(S)
              FReadRec(1, S, 70)
              write(C1,'d',C2,'e',C3,'sc ',C2,': ',C3)
              WriteLn(S)
          EndIf
          Count := Count + 1
          If Count = 2 Count := 0 EndIf
        Until EOF(1)
        FClose(1)
        WriteLn(Bar)
        PauseScr
    EndIf
  EndIf
PEnd View

Proc Search
  If InputYN('~CR'+C1+'d'+C2+'o'+C3+' you want to search for text? ')
    ShowInfo
    Count2 := 0
    Count := 0
    WriteLn(c1,'e',c2,'n',C3,'ter text ',c2,': ',C3)
    Inpt := Input(70, 70, 1, '')
    if inpt<>''
      If Not FExist(file1)
          WriteLn('~CR',c1,'n',c2,'o',C3,' entries available')
          PauseScr
        Else
          FOpen(1, Bin, Reset, file1)
          Repeat
            FReadRec(1, S, 30)
            FReadRec(1, S, 70)
            If Pos(Inpt, S) > 0
                Count2 := Count2 + 1
                fseek(1, filepos(1)-102)
                FReadRec(1, S, 30)
                WriteLn(Bar)
                write(C1,'u',C2,'s',C3,'er ',C2,': ',C3)
                WriteLn(S)
                FReadRec(1, S, 70)
                write(C1,'d',C2,'e',C3,'sc ',C2,': ',C3)
                WriteLn(S)
                WriteLn(Bar)
                NOS := NOS + 4
                If NOS = 16
                    PauseScr
                EndIf
            EndIf
          Until EOF(1)
          FClose(1)
          If Count2 = 0
              WriteLn(Bar)
              WriteLn(C1,'n',C2,'o',C3,' entries containing:')
              WriteLn(Inpt)
              WriteLn(Bar)
          EndIf
          PauseScr
      EndIf
    endif
  EndIf
PEnd Search

Var FO Boolean

Proc Remove
    FO := False
  Entry := 1
  Repeat
    Done := False
    ShowInfo
    WriteLn(C1,'r',c2,'e',c3,'view entries~CR')
        WriteLn(bar)
    If Not FExist(file1)
        WriteLn(c1,'n',c2,'o',C3,' entries available')
        WriteLn(bar)
        PauseScr
        Done := True
      Else
        If Not FO
            If Not FCopy(File1, File2)
                Repeat
                  Delay(10)
                Until FCopy(File2, File1)
            EndIf
            FOpen(2, Bin, Reset, cfgdatapath+'zo-freq.~~~')
            FO := True
        EndIf
        If EOF(2)
            FSeek(2,0)
        EndIf
        entry := filepos(2)/102 +1
        nos := filesize(2)/102
        WriteLn(C1,'e',c2,'n',c3,'try',c2,': ',c3,Entry,c2,'/',c3,nos)
        FReadRec(2, S, 30)
        write(C1,'u',C2,'s',C3,'er ',C2,': ',C3)
        WriteLn(S)
        FReadRec(2, S, 70)
        write(C1,'d',C2,'e',C3,'sc ',C2,': ',C3)
        WriteLn(S)
        WriteLn(bar)
        FSeek(2, FilePos(2)-102)
        WriteLn('~CR',c1,'[',c2,' back  ',c1,']',c2,' foward  ',c1,'d',c2,' delete  ',c1
        ,'e',c2,' edit  ',c1,'j',c2,' jump  ',c1,'q',c2,' quit')
        Inpt := ReadKey
        If Upper(Inpt) = '['
            fpos:=filepos(2)-124
            If FPos<0
                FSeek(2,0)
              else
                FSeek(2, filepos(2)-102)
            endif
          Elseif Upper(Inpt) = ']'
            FPos:=FilePos(2)+102
            If FPos=FileSize(2)
                FSeek(2, FilePos(2))
              Else
                FSeek(2, FilePos(2)+102)
            EndIf
          Elseif Upper(Inpt) = 'J'
            Write('~CR',c1,'j',c2,'u',c3,'mp to entry ',c2,': ',c3)
            Inpt := Input(3, 3, 1, '')
            Temp := Str2Int(Inpt)
            NOS := FileSize(2) / 102 +1
            If Temp <0 And Temp > NOS
              Else
                FSeek(2, Temp * 102 - 102)
            EndIf
          Elseif Upper(Inpt) = 'E'
            Write('~CR',C1,'d',C2,'e',C3,'sc ',c2,': ',c3)
            Desc := Input(70, 70, 1, S)
            If Desc <> ''
                FSeek(2, FilePos(2) + 31)
                FWriteRec(2, Desc, 70)
            EndIf
            FSeek(2, FilePos(2) - 102)
        #  Elseif Upper(Inpt) = 'S'
          Elseif Upper(Inpt) = 'D'
            If Not InputYN('~CR'+c1+'d'+c2+'e'+c3+'lete entry? ')
              Else
                fpos := filepos(2)
                fopen(3,bin,rewrite,'zo-freq.del')
                fseek(2,0)
                count := 0
                if entry = 1
                    writeln('~CR',c1,'c',c2,'a',c3,'nnot delete last entry.  purge instead')
                    pausescr
                  else
                    repeat
                      freadrec(2, user, 30)
                      freadrec(2, desc, 70)
                      count := count + 1
                      if count = entry
                        else
                          fwriterec(3, user, 30)
                          fwriterec(3, desc, 70)
                      endif
                    until eof(2)
                    fclose(3)
                    fclose(2)
                    If Not FCopy('zo-freq.del', File2)
                        Repeat
                          Delay(10)
                        Until FCopy(File2, File1)
                    EndIf
                    fopen(2, bin, reset, file2)
                    fseek(2, fpos-102)
                EndIf
            endif
          ElseIf Upper(Inpt) = 'Q'         
            Done := True
            fclose(2)
            If InputYN('~CR'+C1+'s'+c2+'a'+c3+'ve before quitting? ')
              If Not FCopy(File2, File1)
                  Repeat
                    Delay(10)
                  Until FCopy(File2, File1)
              EndIf
            EndIf
          Else
            WriteLn(C1,'i',C2,'n',C3,'valid command~CR')
            Delay(5)
        EndIf
    EndIf
  Until Done
  Done := False
  ferase(file2)
PEnd Remove

Proc SMenu
  Repeat
  Done := False
  ShowInfo
  WriteLn(C1,'s',C2,'y',c3,'sop menu~CR')
  NOS := 0
  WriteLn(C1,'p]u',c2,'r',C3,'ge database')
  WriteLn(C1,'r]e',C2,'v',C3,'iew entries')
  WriteLn(C1,'s]e',C2,'a',C3,'rch for text')
  WriteLn(C1,'v]i',C2,'e',C3,'w requests')
  WriteLn(C1,'q]u',C2,'i',C3,'t~CR')
  Write(C1,'y',C2,'o',C3,'ur command ',C1,': ',C2)
  Inpt := ReadKey
  If Upper(Inpt) = 'Q'
      Done := True
    Elseif Upper(Inpt) = 'P'
      If InputYN('~CR'+C1+'d'+C2+'o'+C3+' you want to purge the database? ')
        FErase(file1)
        Else
      EndIf
    Elseif Upper(Inpt) = 'R'
      Remove
    Elseif Upper(Inpt) = 'S'
      Search
    Elseif Upper(Inpt) = 'V'
      View
    Else
      WriteLn(C1,'i',C2,'n',C3,'valid command~CR')
      Delay(1)
  EndIf
  Until Done
PEnd SMenu

Proc Menu
  ShowInfo
  NOS := 0
  WriteLn(C1,'r]e',C2,'q',C3,'uest a file')
  WriteLn(C1,'s]e',c2,'a',C3,'rch for text')
  WriteLn(C1,'v]i',C2,'e',C3,'w requests')
  If UserSec = 255
      WriteLn(C1,'*]s',C2,'y',C3,'sop menu')
  EndIf
  WriteLn(C1,'q]u',C2,'i',C3,'t~CR')
  Write(C1,'y',C2,'o',C3,'ur command ',C1,': ',C2)
  Inpt := ReadKey
  If Upper(Inpt) = 'Q'
      If InputYN('~CR'+C1+'d'+C2+'o'+C3+' you want to exit? ')
          WriteLn('~CR',C1,'h',C2,'a',C3,'ve a nice day!')
          SysOpLog('::: '+UserAlias+' exited FReq')
          Halt
        Else
      EndIf
    Elseif Upper(Inpt) = 'R'
      Request
    Elseif Upper(Inpt) = 'V'
      View
    Elseif Upper(Inpt) = 'S'
      Search
    Elseif Upper(Inpt) = '*'
      If UserSec = 255 SMenu EndIf
    Else
      WriteLn(C1,'i',C2,'n',C3,'valid command~CR')
      Delay(1)
  EndIf
PEnd Menu

GetCFG

If FExist(cfgtextpath+'zo-freq.cfg')
    FOpen(1, Text, Reset, cfgtextpath+'zo-freq.cfg')
    FReadLn(1, S)
    Colour := Str2Int(S)
    FClose(1)
  Else
    WriteLn(C1,'zo-freq.cfg does not exist!  please notify your sysop!')
    Halt
Endif

File1 := cfgdatapath+'zo-freq.bin'
File2 := cfgdatapath+'zo-freq.~~~'

If Colour = 0 Or Colour > 7
    Colour := 1
EndIf

C3 := '~08'
C2 := '~0'+Int2Str(Colour)
If Colour = 1
    C1 := '~09'
  ElseIf Colour = 2
    C1 := '~10'
  ElseIf Colour = 3
    C1 := '~11'
  ElseIf Colour = 4
    C1 := '~12'
  ElseIf Colour = 5
    C1 := '~13'
  ElseIf Colour = 6
    C1 := '~14'
  ElseIf Colour = 7
    C1 := '~15'
EndIf

VerLine1  := '~CR'+C1+'F'+C2+'R'+C3+'equest v4 by zoob'
VerLine2  := C1+'-'+C2+'-'+C3+'------------------'+C2+'-'+C1+'-~CR'
Bar       := C3+''
Pause_Str := C1+'p'+C2+'a'+C3+'used'
NOS := 0

GetThisUser
SysOpLog('::: '+UserAlias+' entered FReq')

Repeat
  Menu
Until Inpt = 'Q'
