Unit comOpen;           { Open a Communications Port }

{
     comOpen - Copyright 1998 by Brian Zhou
     You are free to use this code in your programs, however
     it may not be included in Source/TPU function libraries
     without my permission.

     You may reach me at zoob@darktech.org
}

Interface

Uses comAbs;

Function initComPtr(Var Com : pAbsComm; Driver: byte) : boolean;
Function InitMComPtr(Com : pAbsComm; Port,Irq : Byte; Baud, Addr : Word): Boolean;
Function DoneComPtr(Var Com: pAbsComm) : Boolean;

Implementation

Uses comAsync, comFos;

{ ::: initialize object pointer }
Function initComPtr(Var Com : pAbsComm; Driver: byte) : boolean;
  begin
    Com := Nil;
    InitComPtr := True;
    Case Driver Of
      1 : Com := New(pFosComm, Init);
      2 : Com := New(pAsyncComm, Init);
      Else
        initComPtr := False;
    End;
  end;

{ ::: install modem procedures }
Function InitMComPtr(Com : pAbsComm; Port,Irq : Byte; Baud, Addr : Word): Boolean;
  begin
      initMcomptr:=true;
      pIrq := irq; pBase := Addr;
      If Com^.Install(Port, baud)=false then initMComPtr := False;
  end;

{ ::: deinitialize object pointer }
Function DoneComPtr(Var Com: pAbsComm) : Boolean;
  begin
    Com^.Deinstall;
    If Com <> Nil Then
      Dispose(Com, Done);
    Com := Nil;
  end;

end.
